/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Ignition
extends PEToggleItem
implements IPedestalItem,
IFireProtector,
IProjectileShooter {
    public Ignition(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int inventorySlot, boolean held) {
        if (world.field_72995_K || inventorySlot >= PlayerInventory.func_70451_h() || !(entity instanceof PlayerEntity)) {
            return;
        }
        super.func_77663_a(stack, world, entity, inventorySlot, held);
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n("Active")) {
            if (Ignition.getEmc(stack) == 0L && !Ignition.consumeFuel((PlayerEntity)player, stack, 64L, false)) {
                nbt.func_74757_a("Active", false);
            } else {
                WorldHelper.igniteNearby(world, (PlayerEntity)player);
                Ignition.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, 0.32f));
            }
        } else {
            WorldHelper.extinguishNearby(world, (PlayerEntity)player);
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext ctx) {
        return WorldHelper.igniteBlock(ctx);
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.cooldown.pedestal.ignition.get() != -1 && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            if (tile.getActivityCooldown() == 0) {
                List list = world.func_217357_a(MobEntity.class, tile.getEffectBounds());
                for (MobEntity living : list) {
                    living.func_70097_a(DamageSource.field_76372_a, 3.0f);
                    living.func_70015_d(8);
                }
                tile.setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.ignition.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.cooldown.pedestal.ignition.get() != -1) {
            list.add((ITextComponent)PELang.PEDESTAL_IGNITION_1.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_IGNITION_2.translateColored(TextFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.ignition.get())));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return false;
        }
        EntityFireProjectile fire = new EntityFireProjectile(player, world);
        fire.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        world.func_217376_c((Entity)fire);
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, ServerPlayerEntity player) {
        return true;
    }
}

