/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotGhost;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.utils.ContainerHelper;
import moze_intel.projecte.utils.GuiHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.items.IItemHandler;

public class CollectorMK1Container
extends PEContainer {
    public final CollectorMK1Tile tile;
    public final IntReferenceHolder sunLevel = IntReferenceHolder.func_221492_a();
    public final PEContainer.BoxedLong emc = new PEContainer.BoxedLong();
    private final IntReferenceHolder kleinChargeProgress = IntReferenceHolder.func_221492_a();
    private final IntReferenceHolder fuelProgress = IntReferenceHolder.func_221492_a();
    public final PEContainer.BoxedLong kleinEmc = new PEContainer.BoxedLong();

    public static CollectorMK1Container fromNetwork(int windowId, PlayerInventory playerInv, PacketBuffer buf) {
        return new CollectorMK1Container(windowId, playerInv, (CollectorMK1Tile)GuiHandler.getTeFromBuf(buf));
    }

    public CollectorMK1Container(int windowId, PlayerInventory invPlayer, CollectorMK1Tile collector) {
        this(PEContainerTypes.COLLECTOR_MK1_CONTAINER, windowId, invPlayer, collector);
    }

    protected CollectorMK1Container(ContainerTypeRegistryObject<? extends CollectorMK1Container> type, int windowId, PlayerInventory invPlayer, CollectorMK1Tile collector) {
        super((ContainerType)type.get(), windowId);
        this.longFields.add(this.emc);
        this.intFields.add(this.sunLevel);
        this.intFields.add(this.kleinChargeProgress);
        this.intFields.add(this.fuelProgress);
        this.longFields.add(this.kleinEmc);
        this.tile = collector;
        this.initSlots(invPlayer);
    }

    void initSlots(PlayerInventory invPlayer) {
        IItemHandler aux = this.tile.getAux();
        IItemHandler main = this.tile.getInput();
        this.func_75146_a((Slot)new ValidatedSlot(aux, 0, 124, 58, SlotPredicates.COLLECTOR_INV));
        int counter = main.getSlots() - 1;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot(main, counter--, 20 + i * 18, 8 + j * 18, SlotPredicates.COLLECTOR_INV));
            }
        }
        this.func_75146_a((Slot)new ValidatedSlot(aux, 1, 124, 13, SlotPredicates.COLLECTOR_INV));
        this.func_75146_a((Slot)new SlotGhost(aux, 2, 153, 36, SlotPredicates.COLLECTOR_LOCK));
        ContainerHelper.addPlayerInventory(arg_0 -> ((CollectorMK1Container)this).func_75146_a(arg_0), (IInventory)invPlayer, 8, 84);
    }

    @Nonnull
    public ItemStack func_184996_a(int slotID, int button, @Nonnull ClickType flag, @Nonnull PlayerEntity player) {
        Slot slot;
        if (slotID >= 0 && (slot = this.func_75139_a(slotID)) instanceof SlotGhost && !slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotID, button, flag, player);
    }

    @Override
    public void func_75142_b() {
        this.emc.set(this.tile.getStoredEmc());
        this.sunLevel.func_221494_a(this.tile.getSunLevel());
        this.kleinChargeProgress.func_221494_a((int)(this.tile.getItemChargeProportion() * 8000.0));
        this.fuelProgress.func_221494_a((int)(this.tile.getFuelProgress() * 8000.0));
        this.kleinEmc.set(this.tile.getItemCharge());
        super.func_75142_b();
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex <= 10) {
            if (!this.func_75135_a(stack, 11, 46, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (slotIndex <= 46) {
            if (!FuelMapper.isStackFuel(stack) || FuelMapper.isStackMaxFuel(stack) || !this.func_75135_a(stack, 1, 8, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(player, stack);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return player.field_70170_p.func_180495_p(this.tile.func_174877_v()).func_177230_c() == PEBlocks.COLLECTOR.getBlock() && player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public double getKleinChargeProgress() {
        return (double)this.kleinChargeProgress.func_221495_b() / 8000.0;
    }

    public double getFuelProgress() {
        return (double)this.fuelProgress.func_221495_b() / 8000.0;
    }
}

