/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.nbt.processor;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.api.nbt.NBTProcessor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@NBTProcessor(priority=0x7FFFFFFF)
public class DamageProcessor
implements INBTProcessor {
    @Override
    public String getName() {
        return "DamageProcessor";
    }

    @Override
    public String getDescription() {
        return "Reduces the EMC value the more damaged an item is.";
    }

    @Override
    public long recalculateEMC(@Nonnull ItemInfo info, long currentEMC) throws ArithmeticException {
        Item item = info.getItem();
        if (item.func_77645_m()) {
            ItemStack fakeStack = info.createStack();
            int maxDamage = item.getMaxDamage(fakeStack);
            int damage = item.getDamage(fakeStack);
            if (damage > maxDamage) {
                throw new ArithmeticException();
            }
            currentEMC = Math.multiplyExact(currentEMC, (long)Math.addExact(maxDamage - damage, 1)) / (long)maxDamage;
        }
        return currentEMC;
    }
}

