/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.trees.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.worldgen.trees.config.BaseSlimeTreeFeatureConfig;

public class SlimeTreeFeature
extends Feature<BaseSlimeTreeFeatureConfig> {
    public SlimeTreeFeature(Codec<BaseSlimeTreeFeatureConfig> codec) {
        super(codec);
    }

    public final boolean generate(ISeedReader seedReader, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, BaseSlimeTreeFeatureConfig config) {
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.place((IWorldGenerationReader)seedReader, random, blockPos, set, set1, mutableboundingbox, config);
        if (mutableboundingbox.field_78897_a <= mutableboundingbox.field_78893_d && flag && !set.isEmpty()) {
            VoxelShapePart voxelshapepart = this.func_236403_a_((IWorld)seedReader, mutableboundingbox, set, set2);
            Template.func_222857_a((IWorld)seedReader, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
            return true;
        }
        return false;
    }

    private boolean place(IWorldGenerationReader generationReader, Random rand, BlockPos positionIn, Set<BlockPos> trunkBlockPosSet, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBoxIn, BaseSlimeTreeFeatureConfig configIn) {
        int height = rand.nextInt(configIn.randomHeight) + configIn.baseHeight;
        if (!(generationReader instanceof IWorld)) {
            return false;
        }
        if (positionIn.func_177956_o() >= 1 && positionIn.func_177956_o() + height + 1 <= 256) {
            if (!SlimeTreeFeature.isDirtOrFarmlandAt((IWorldGenerationBaseReader)generationReader, positionIn.func_177977_b())) {
                return false;
            }
            this.setDirtAt(generationReader, positionIn.func_177977_b(), positionIn);
            this.placeTrunk(generationReader, rand, height, positionIn, trunkBlockPosSet, boundingBoxIn, configIn);
            this.placeCanopy(generationReader, rand, height, positionIn, trunkBlockPosSet, boundingBoxIn, configIn);
            return true;
        }
        return false;
    }

    protected void setDirtAt(IWorldGenerationReader reader, BlockPos pos, BlockPos origin) {
        if (!(reader instanceof IWorld)) {
            return;
        }
        ((IWorld)reader).func_180495_p(pos).func_177230_c().onPlantGrow(((IWorld)reader).func_180495_p(pos), (IWorld)reader, pos, origin);
    }

    protected void placeTrunk(IWorldGenerationReader worldIn, Random randomIn, int treeHeight, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, BaseSlimeTreeFeatureConfig treeFeatureConfigIn) {
        while (treeHeight > 0) {
            this.setLog(worldIn, randomIn, blockPos, blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            blockPos = blockPos.func_177984_a();
            --treeHeight;
        }
    }

    protected void placeCanopy(IWorldGenerationReader worldIn, Random randomIn, int treeHeight, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, BaseSlimeTreeFeatureConfig treeFeatureConfigIn) {
        blockPos = blockPos.func_177981_b(treeHeight);
        for (int i = 0; i < 4; ++i) {
            this.placeDiamondLayer(worldIn, randomIn, i + 1, blockPos.func_177979_c(i), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        }
        blockPos = blockPos.func_177979_c(3);
        this.placeAir(worldIn, randomIn, blockPos.func_177982_a(4, 0, 0), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.func_177982_a(-4, 0, 0), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.func_177982_a(0, 0, 4), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.func_177982_a(0, 0, -4), blockPosSet, mutableBoundingBoxIn);
        if (treeFeatureConfigIn.hasVines) {
            this.placeAir(worldIn, randomIn, blockPos.func_177982_a(1, 0, 1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.func_177982_a(1, 0, -1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.func_177982_a(-1, 0, 1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.func_177982_a(-1, 0, -1), blockPosSet, mutableBoundingBoxIn);
        }
        blockPos = blockPos.func_177977_b();
        this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(0, 0, -3), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(0, 0, 3), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        if (!treeFeatureConfigIn.hasVines) {
            this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(1, 0, 1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(-1, 0, 1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(-1, 0, -1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        }
        if (treeFeatureConfigIn.hasVines) {
            blockPos = blockPos.func_177977_b();
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(3, 0, 0), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(0, 0, -3), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(0, 0, 3), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            BlockState randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(2, 1, 2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(2, 0, 2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(2, 1, -2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(2, 0, -2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-2, 1, 2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-2, 0, 2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-2, 1, -2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-2, 0, -2), blockPosSet, mutableBoundingBoxIn, randomVine);
        }
    }

    private void placeDiamondLayer(IWorldGenerationReader worldIn, Random randomIn, int range, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, BaseSlimeTreeFeatureConfig treeFeatureConfigIn) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) + Math.abs(z) > range) continue;
                BlockPos blockpos = blockPos.func_177982_a(x, 0, z);
                this.setLeaf(worldIn, randomIn, blockpos, blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            }
        }
    }

    protected boolean setLog(IWorldGenerationReader worldIn, Random randomIn, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, BaseSlimeTreeFeatureConfig treeFeatureConfigIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)worldIn, blockPos)) {
            return false;
        }
        this.func_230367_a_((IWorldWriter)worldIn, blockPos, treeFeatureConfigIn.trunkProvider.func_225574_a_(randomIn, blockPos));
        mutableBoundingBoxIn.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
        blockPosSet.add(blockPos.func_185334_h());
        return true;
    }

    protected boolean placeAir(IWorldGenerationReader worldIn, Random randomIn, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)worldIn, blockPos)) {
            return false;
        }
        this.func_230367_a_((IWorldWriter)worldIn, blockPos, Blocks.field_150350_a.func_176223_P());
        mutableBoundingBoxIn.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
        blockPosSet.add(blockPos.func_185334_h());
        return true;
    }

    protected boolean setLeaf(IWorldGenerationReader worldIn, Random random, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, BaseSlimeTreeFeatureConfig treeFeatureConfigIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)worldIn, blockPos)) {
            return false;
        }
        this.func_230367_a_((IWorldWriter)worldIn, blockPos, treeFeatureConfigIn.leavesProvider.func_225574_a_(random, blockPos));
        mutableBoundingBoxIn.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
        blockPosSet.add(blockPos.func_185334_h());
        return true;
    }

    protected boolean placeVine(IWorldGenerationReader worldIn, Random random, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, BlockState vineState) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)worldIn, blockPos)) {
            return false;
        }
        this.func_230367_a_((IWorldWriter)worldIn, blockPos, vineState);
        mutableBoundingBoxIn.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
        blockPosSet.add(blockPos.func_185334_h());
        return true;
    }

    private BlockState getRandomizedVine(Random random, BlockPos blockPos, BaseSlimeTreeFeatureConfig config) {
        BooleanProperty[] sides;
        BlockState state = config.vinesProvider.func_225574_a_(random, blockPos);
        for (BooleanProperty side : sides = new BooleanProperty[]{VineBlock.field_176273_b, VineBlock.field_176278_M, VineBlock.field_176279_N, VineBlock.field_176280_O}) {
            state = (BlockState)state.func_206870_a((Property)side, (Comparable)Boolean.valueOf(false));
        }
        for (int i = random.nextInt(3) + 1; i > 0; --i) {
            state = (BlockState)state.func_206870_a((Property)sides[random.nextInt(sides.length)], (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean isEmptyOrLogAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return SlimeTreeFeature.isReplaceableAt(reader, blockPos) || reader.func_217375_a(blockPos, p_236417_0_ -> p_236417_0_.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    private static boolean isVineAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, p_236415_0_ -> p_236415_0_.func_203425_a(Blocks.field_150395_bd));
    }

    private static boolean isWaterAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, p_236413_0_ -> p_236413_0_.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isAirOrLeavesAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, p_236411_0_ -> p_236411_0_.func_196958_f() || p_236411_0_.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isDirtOrFarmlandAt(IWorldGenerationBaseReader p_236418_0_, BlockPos blockPos) {
        return p_236418_0_.func_217375_a(blockPos, p_236409_0_ -> {
            Block block = p_236409_0_.func_177230_c();
            return TinkerWorld.slimeDirt.contains((IForgeRegistryEntry)block) || TinkerWorld.vanillaSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.earthSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.skySlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.enderSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.ichorSlimeGrass.contains((IForgeRegistryEntry)block);
        });
    }

    private static boolean isTallPlantAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, p_236406_0_ -> {
            Material material = p_236406_0_.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    public static boolean isReplaceableAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return SlimeTreeFeature.isAirOrLeavesAt(reader, blockPos) || SlimeTreeFeature.isTallPlantAt(reader, blockPos) || SlimeTreeFeature.isWaterAt(reader, blockPos);
    }

    public static void setBlockStateAt(IWorldWriter writer, BlockPos blockPos, BlockState state) {
        writer.func_180501_a(blockPos, state, 19);
    }

    private VoxelShapePart func_236403_a_(IWorld world, MutableBoundingBox boundingBox, Set<BlockPos> logs, Set<BlockPos> leaves) {
        ArrayList list = Lists.newArrayList();
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(boundingBox.func_78883_b(), boundingBox.func_78882_c(), boundingBox.func_78880_d());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : Lists.newArrayList(leaves)) {
            if (!boundingBox.func_175898_b((Vector3i)blockpos)) continue;
            voxelshapepart.func_199625_a(blockpos.func_177958_n() - boundingBox.field_78897_a, blockpos.func_177956_o() - boundingBox.field_78895_b, blockpos.func_177952_p() - boundingBox.field_78896_c, true, true);
        }
        for (BlockPos blockpos1 : Lists.newArrayList(logs)) {
            if (boundingBox.func_175898_b((Vector3i)blockpos1)) {
                voxelshapepart.func_199625_a(blockpos1.func_177958_n() - boundingBox.field_78897_a, blockpos1.func_177956_o() - boundingBox.field_78895_b, blockpos1.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                mutable.func_239622_a_((Vector3i)blockpos1, direction);
                if (logs.contains(mutable) || !(blockstate = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)list.get(0)).add(mutable.func_185334_h());
                SlimeTreeFeature.setBlockStateAt((IWorldWriter)world, (BlockPos)mutable, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                if (!boundingBox.func_175898_b((Vector3i)mutable)) continue;
                voxelshapepart.func_199625_a(mutable.func_177958_n() - boundingBox.field_78897_a, mutable.func_177956_o() - boundingBox.field_78895_b, mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (boundingBox.func_175898_b((Vector3i)blockpos2)) {
                    voxelshapepart.func_199625_a(blockpos2.func_177958_n() - boundingBox.field_78897_a, blockpos2.func_177956_o() - boundingBox.field_78895_b, blockpos2.func_177952_p() - boundingBox.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    mutable.func_239622_a_((Vector3i)blockpos2, direction1);
                    if (set.contains(mutable) || set1.contains(mutable) || !(blockstate1 = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                    SlimeTreeFeature.setBlockStateAt((IWorldWriter)world, (BlockPos)mutable, blockstate2);
                    if (boundingBox.func_175898_b((Vector3i)mutable)) {
                        voxelshapepart.func_199625_a(mutable.func_177958_n() - boundingBox.field_78897_a, mutable.func_177956_o() - boundingBox.field_78895_b, mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
                    }
                    set1.add(mutable.func_185334_h());
                }
            }
        }
        return voxelshapepart;
    }
}

