/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.trees.Tree;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;
import slimeknights.tconstruct.world.worldgen.trees.config.BaseSlimeTreeFeatureConfig;

public class SlimeTree
extends Tree {
    private final SlimeGrassBlock.FoliageType foliageType;

    public SlimeTree(SlimeGrassBlock.FoliageType foliageType) {
        this.foliageType = foliageType;
    }

    @Deprecated
    @Nullable
    protected ConfiguredFeature<BaseTreeFeatureConfig, ?> func_225546_b_(Random randomIn, boolean largeHive) {
        return null;
    }

    @Nullable
    public ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> getSlimeTreeFeature(Random randomIn, boolean largeHive) {
        switch (this.foliageType) {
            case SKY: {
                return TinkerStructures.SKY_SLIME_TREE;
            }
            case ENDER: {
                return TinkerStructures.ENDER_SLIME_TREE;
            }
            case BLOOD: {
                return TinkerStructures.BLOOD_SLIME_TREE;
            }
            case ICHOR: {
                return TinkerStructures.ICHOR_SLIME_TREE;
            }
        }
        return null;
    }

    public boolean func_230339_a_(ServerWorld world, ChunkGenerator chunkGenerator, BlockPos pos, BlockState state, Random rand) {
        ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> configuredFeature = this.getSlimeTreeFeature(rand, this.hasNearbyFlora((IWorld)world, pos));
        if (configuredFeature == null) {
            return false;
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        ((BaseSlimeTreeFeatureConfig)configuredFeature.field_222738_b).forcePlacement();
        if (configuredFeature.func_242765_a((ISeedReader)world, chunkGenerator, rand, pos)) {
            return true;
        }
        world.func_180501_a(pos, state, 4);
        return false;
    }

    private boolean hasNearbyFlora(IWorld world, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177977_b().func_177964_d(2).func_177985_f(2), (BlockPos)pos.func_177984_a().func_177970_e(2).func_177965_g(2))) {
            if (!world.func_180495_p(blockpos).func_235714_a_((ITag)BlockTags.field_226149_I_)) continue;
            return true;
        }
        return false;
    }
}

