/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.trees.config.BaseSlimeTreeFeatureConfig;

public enum SlimeIslandVariant implements IStringSerializable
{
    SKY(0, ((SlimeGrassBlock)TinkerWorld.skySlimeGrass.get((Enum)SlimeGrassBlock.FoliageType.SKY)).func_176223_P(), (Block)Objects.requireNonNull(TinkerFluids.skySlime.getBlock()), SlimeIslandVariant.createArray(((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY)).func_176223_P(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH)).func_176223_P()), ((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).func_176223_P(), SlimeIslandVariant.createArray(((SlimeTallGrassBlock)TinkerWorld.slimeFern.get((Enum)SlimeGrassBlock.FoliageType.SKY)).func_176223_P(), ((SlimeTallGrassBlock)TinkerWorld.slimeTallGrass.get((Enum)SlimeGrassBlock.FoliageType.SKY)).func_176223_P()), TinkerStructures.SKY_SLIME_ISLAND_TREE, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a),
    EARTH(1, ((SlimeGrassBlock)TinkerWorld.earthSlimeGrass.get((Enum)SlimeGrassBlock.FoliageType.SKY)).func_176223_P(), (Block)TinkerFluids.skySlime.getBlock(), SlimeIslandVariant.createArray(((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY)).func_176223_P(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH)).func_176223_P()), ((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).func_176223_P(), SlimeIslandVariant.createArray(((SlimeTallGrassBlock)TinkerWorld.slimeFern.get((Enum)SlimeGrassBlock.FoliageType.SKY)).func_176223_P(), ((SlimeTallGrassBlock)TinkerWorld.slimeTallGrass.get((Enum)SlimeGrassBlock.FoliageType.SKY)).func_176223_P()), TinkerStructures.SKY_SLIME_ISLAND_TREE, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a),
    ENDER(2, ((SlimeGrassBlock)TinkerWorld.enderSlimeGrass.get((Enum)SlimeGrassBlock.FoliageType.ENDER)).func_176223_P(), (Block)Objects.requireNonNull(TinkerFluids.enderSlime.getBlock()), SlimeIslandVariant.createArray(((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ENDER)).func_176223_P()), ((SlimeVineBlock)TinkerWorld.enderSlimeVine.get()).func_176223_P(), SlimeIslandVariant.createArray(((SlimeTallGrassBlock)TinkerWorld.slimeFern.get((Enum)SlimeGrassBlock.FoliageType.ENDER)).func_176223_P(), ((SlimeTallGrassBlock)TinkerWorld.slimeTallGrass.get((Enum)SlimeGrassBlock.FoliageType.ENDER)).func_176223_P()), TinkerStructures.ENDER_SLIME_ISLAND_TREE, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a),
    BLOOD(3, ((SlimeGrassBlock)TinkerWorld.ichorSlimeGrass.get((Enum)SlimeGrassBlock.FoliageType.BLOOD)).func_176223_P(), (Block)Objects.requireNonNull(TinkerFluids.magmaCream.getBlock()), SlimeIslandVariant.createArray(((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).func_176223_P(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.BLOOD)).func_176223_P()), null, SlimeIslandVariant.createArray(((SlimeTallGrassBlock)TinkerWorld.slimeFern.get((Enum)SlimeGrassBlock.FoliageType.BLOOD)).func_176223_P(), ((SlimeTallGrassBlock)TinkerWorld.slimeTallGrass.get((Enum)SlimeGrassBlock.FoliageType.BLOOD)).func_176223_P()), TinkerStructures.BLOOD_SLIME_TREE, (StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);

    private final int index;
    private final BlockState lakeBottom;
    private final BlockState lakeFluid;
    private final BlockState[] congealedSlime;
    @Nullable
    private final BlockState vine;
    private final BlockState[] tallGrass;
    private final ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> configuredTreeFeature;
    private final StructureProcessor structureProcessor;

    private SlimeIslandVariant(int index, BlockState lakeBottom, @Nullable Block lakeFluid, BlockState[] congealedSlime, BlockState vine, BlockState[] tallGrass, ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> configuredTreeFeature, StructureProcessor structureProcessor) {
        this.index = index;
        this.lakeBottom = lakeBottom;
        this.lakeFluid = lakeFluid.func_176223_P();
        this.congealedSlime = congealedSlime;
        this.vine = vine;
        this.tallGrass = tallGrass;
        this.configuredTreeFeature = configuredTreeFeature;
        this.structureProcessor = structureProcessor;
    }

    private static BlockState[] createArray(BlockState ... states) {
        return states;
    }

    public String func_176610_l() {
        return this.toString().toLowerCase(Locale.US);
    }

    public static SlimeIslandVariant getVariantFromIndex(int index) {
        switch (index) {
            case 0: {
                return SKY;
            }
            case 1: {
                return EARTH;
            }
            case 2: {
                return ENDER;
            }
            case 3: {
                return BLOOD;
            }
        }
        throw new IllegalStateException("Unexpected variant: " + index);
    }

    public int getIndex() {
        return this.index;
    }

    public BlockState getLakeBottom() {
        return this.lakeBottom;
    }

    public BlockState getLakeFluid() {
        return this.lakeFluid;
    }

    public BlockState[] getCongealedSlime() {
        return this.congealedSlime;
    }

    @Nullable
    public BlockState getVine() {
        return this.vine;
    }

    public BlockState[] getTallGrass() {
        return this.tallGrass;
    }

    public ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> getConfiguredTreeFeature() {
        return this.configuredTreeFeature;
    }

    public StructureProcessor getStructureProcessor() {
        return this.structureProcessor;
    }
}

