/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.SlimeIslandVariant;
import slimeknights.tconstruct.world.worldgen.trees.config.BaseSlimeTreeFeatureConfig;

public class SlimeIslandPiece
extends TemplateStructurePiece {
    private final String templateName;
    private final SlimeIslandVariant variant;
    private final Rotation rotation;
    private final Mirror mirror;
    private int numberOfTreesPlaced;
    private ChunkGenerator chunkGenerator;

    public SlimeIslandPiece(TemplateManager templateManager, SlimeIslandVariant variant, String templateName, BlockPos templatePosition, Rotation rotation) {
        this(templateManager, variant, templateName, templatePosition, rotation, Mirror.NONE);
    }

    public SlimeIslandPiece(TemplateManager templateManager, SlimeIslandVariant variant, String templateName, BlockPos templatePosition, Rotation rotation, Mirror mirror) {
        super(TinkerStructures.slimeIslandPiece, 0);
        this.templateName = templateName;
        this.variant = variant;
        this.field_186178_c = templatePosition;
        this.rotation = rotation;
        this.mirror = mirror;
        this.numberOfTreesPlaced = 0;
        this.loadTemplate(templateManager);
    }

    public SlimeIslandPiece(TemplateManager templateManager, CompoundNBT nbt) {
        super(TinkerStructures.slimeIslandPiece, nbt);
        this.templateName = nbt.func_74779_i("Template");
        this.variant = SlimeIslandVariant.getVariantFromIndex(nbt.func_74762_e("Variant"));
        this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.mirror = Mirror.valueOf((String)nbt.func_74779_i("Mi"));
        this.numberOfTreesPlaced = nbt.func_74762_e("NumberOfTreesPlaced");
        this.loadTemplate(templateManager);
    }

    private void loadTemplate(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(new ResourceLocation("tconstruct:slime_islands/" + this.variant.func_176610_l() + "/" + this.templateName));
        PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_186214_a(this.mirror).func_215222_a(this.variant.getStructureProcessor());
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74778_a("Template", this.templateName);
        tagCompound.func_74768_a("Variant", this.variant.getIndex());
        tagCompound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
        tagCompound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
        tagCompound.func_74768_a("NumberOfTreesPlaced", this.numberOfTreesPlaced);
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        switch (function) {
            case "tconstruct:lake_bottom": {
                worldIn.func_180501_a(pos, this.variant.getLakeBottom(), 2);
                break;
            }
            case "tconstruct:slime_fluid": {
                worldIn.func_180501_a(pos, this.variant.getLakeFluid(), 2);
                break;
            }
            case "tconstruct:congealed_slime": {
                int congealed_slime_random = rand.nextInt(this.variant.getCongealedSlime().length);
                worldIn.func_180501_a(pos, this.variant.getCongealedSlime()[congealed_slime_random], 2);
                break;
            }
            case "tconstruct:slime_vine": {
                if (this.variant.getVine() != null) {
                    if (rand.nextBoolean()) {
                        this.placeVine((IWorld)worldIn, pos, rand, this.variant.getVine());
                        break;
                    }
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    break;
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                break;
            }
            case "tconstruct:slime_tree": {
                ISeedReader seedReader;
                ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> treeFeature;
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                if (this.numberOfTreesPlaced >= 3 || !rand.nextBoolean() || (treeFeature = this.variant.getConfiguredTreeFeature()) == null || !(worldIn instanceof ISeedReader) || !treeFeature.func_242765_a(seedReader = (ISeedReader)worldIn, this.chunkGenerator, rand, pos)) break;
                ++this.numberOfTreesPlaced;
                break;
            }
            case "tconstruct:slime_tall_grass": {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                if (!rand.nextBoolean()) break;
                int slime_grass_random = rand.nextInt(this.variant.getTallGrass().length);
                BlockState state = this.variant.getTallGrass()[slime_grass_random];
                if (!(state.func_177230_c() instanceof SlimeTallGrassBlock) || !((SlimeTallGrassBlock)state.func_177230_c()).func_196260_a(state, (IWorldReader)worldIn, pos)) break;
                worldIn.func_180501_a(pos, state, 2);
            }
        }
    }

    private void placeVine(IWorld worldIn, BlockPos pos, Random random, BlockState vineToPlace) {
        BlockState state;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !SlimeVineBlock.func_196542_b((IBlockReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction)) continue;
            worldIn.func_180501_a(pos, (BlockState)vineToPlace.func_206870_a((Property)SlimeVineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.TRUE), 2);
        }
        BlockPos vinePos = pos;
        for (int size = random.nextInt(8); size >= 0 && (state = worldIn.func_180495_p(vinePos)).func_177230_c() instanceof SlimeVineBlock; --size) {
            ((SlimeVineBlock)state.func_177230_c()).grow(worldIn, random, vinePos, state);
            vinePos = vinePos.func_177977_b();
        }
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox bounds, ChunkPos chunk, BlockPos pos) {
        this.chunkGenerator = generator;
        if (this.variant == SlimeIslandVariant.BLOOD) {
            BlockPos up = this.field_186178_c.func_177984_a();
            if (this.isLava((IWorld)world, up)) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    if (this.isLava((IWorld)world, up.func_177972_a(dir))) continue;
                    return false;
                }
                return super.func_230383_a_(world, manager, generator, rand, bounds, chunk, pos);
            }
            return false;
        }
        return super.func_230383_a_(world, manager, generator, rand, bounds, chunk, pos);
    }

    private boolean isLava(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l;
    }
}

