/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

public class SlimeColorizer {
    private static final Map<SlimeGrassBlock.FoliageType, int[]> COLOR_MAP = (Map)Util.func_200696_a(new EnumMap(SlimeGrassBlock.FoliageType.class), map -> {
        for (SlimeGrassBlock.FoliageType type : SlimeGrassBlock.FoliageType.values()) {
            map.put(type, new int[65536]);
        }
    });
    public static final float LOOP = 256.0f;
    public static final BlockPos LOOP_OFFSET = new BlockPos(128.0, 0.0, 128.0);

    public static void setGrassColor(SlimeGrassBlock.FoliageType type, int[] colors) {
        COLOR_MAP.put(type, colors);
    }

    public static int getColor(SlimeGrassBlock.FoliageType type, int x, int z) {
        return SlimeColorizer.getColor(COLOR_MAP.get((Object)type), x, z);
    }

    public static int getColorForPos(BlockPos pos, SlimeGrassBlock.FoliageType type) {
        return SlimeColorizer.getColor(type, pos.func_177958_n(), pos.func_177952_p());
    }

    private static int getColor(int[] buffer, int posX, int posZ) {
        float z;
        float x = Math.abs((256.0f - (float)Math.abs(posX) % 512.0f) / 256.0f);
        if (x < (z = Math.abs((256.0f - (float)Math.abs(posZ) % 512.0f) / 256.0f))) {
            float tmp = x;
            x = z;
            z = tmp;
        }
        return buffer[(int)(x * 255.0f) << 8 | (int)(z * 255.0f)];
    }

    public static int getColorStatic(SlimeGrassBlock.FoliageType type) {
        return type.getDefaultColor();
    }
}

