/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

public class SlimeVineBlock
extends VineBlock {
    public static final EnumProperty<VineStage> STAGE = EnumProperty.func_177709_a((String)"stage", VineStage.class);
    private final SlimeGrassBlock.FoliageType foliage;

    public SlimeVineBlock(AbstractBlock.Properties properties, SlimeGrassBlock.FoliageType foliage) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(STAGE, (Comparable)((Object)VineStage.START)));
        this.foliage = foliage;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{STAGE});
    }

    public SlimeGrassBlock.FoliageType getFoliageType() {
        return this.foliage;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (SlimeVineBlock.hasNoHorizontalSides(state)) {
            BlockState newState = state;
            boolean onLeaves = worldIn.func_180495_p(pos.func_177984_a()).func_235714_a_(TinkerTags.Blocks.SLIMY_LEAVES);
            for (Direction side : Direction.Plane.HORIZONTAL) {
                if (!onLeaves && !SlimeVineBlock.func_196542_b((IBlockReader)worldIn, (BlockPos)pos.func_177972_a(side), (Direction)side) || random.nextInt(6) != 0) continue;
                newState = (BlockState)newState.func_206870_a((Property)SlimeVineBlock.func_176267_a((Direction)side), (Comparable)Boolean.valueOf(true));
            }
            if (newState != state) {
                worldIn.func_180501_a(pos, newState, 3);
            }
        } else if (random.nextInt(4) == 0) {
            this.grow((IWorld)worldIn, random, pos, state);
        }
    }

    public void grow(IWorld worldIn, Random random, BlockPos pos, BlockState state) {
        if (SlimeVineBlock.hasNoHorizontalSides(state) || state.func_177229_b(STAGE) == VineStage.END) {
            return;
        }
        BlockPos below = pos.func_177977_b();
        if (worldIn.func_175623_d(below)) {
            if (SlimeVineBlock.freeFloating(worldIn, pos, state)) {
                BlockState above;
                int i;
                VineStage stage = (VineStage)((Object)state.func_177229_b(STAGE));
                for (i = 1; i < 3 && (above = worldIn.func_180495_p(pos.func_177981_b(i))).func_203425_a((Block)this) && above.func_177229_b(STAGE) == stage; ++i) {
                }
                if (i > 2 || random.nextInt(2) == 0) {
                    state = (BlockState)state.func_235896_a_(STAGE);
                }
            }
            worldIn.func_180501_a(below, (BlockState)state.func_206870_a((Property)field_176277_a, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return SlimeVineBlock.hasSides(this.updateConnections(state, (IBlockReader)worldIn, pos));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        BlockState updated = this.updateConnections(stateIn, (IBlockReader)worldIn, currentPos);
        return !SlimeVineBlock.hasSides(updated) ? Blocks.field_150350_a.func_176223_P() : updated;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState currState = world.func_180495_p(pos = context.func_195995_a());
        boolean isVine = currState.func_203425_a((Block)this);
        BlockState vineState = isVine ? currState : this.func_176223_P();
        for (Direction direction : context.func_196009_e()) {
            if (direction == Direction.DOWN) continue;
            BooleanProperty prop = SlimeVineBlock.func_176267_a((Direction)direction);
            if (isVine && ((Boolean)currState.func_177229_b((Property)prop)).booleanValue() || !this.hasAttachment((IBlockReader)world, pos, direction)) continue;
            return (BlockState)vineState.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return isVine ? vineState : null;
    }

    private static boolean hasSides(BlockState state) {
        for (BooleanProperty booleanproperty : field_196546_A.values()) {
            if (!((Boolean)state.func_177229_b((Property)booleanproperty)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNoHorizontalSides(BlockState state) {
        for (Direction side : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)state.func_177229_b((Property)SlimeVineBlock.func_176267_a((Direction)side))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean freeFloating(IWorld world, BlockPos pos, BlockState state) {
        for (Direction side : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)state.func_177229_b((Property)SlimeVineBlock.func_176267_a((Direction)side))).booleanValue() || !SlimeVineBlock.func_196542_b((IBlockReader)world, (BlockPos)pos.func_177972_a(side), (Direction)side)) continue;
            return false;
        }
        return true;
    }

    private BlockState updateConnections(BlockState state, IBlockReader world, BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        if (((Boolean)state.func_177229_b((Property)field_176277_a)).booleanValue()) {
            state = (BlockState)state.func_206870_a((Property)field_176277_a, (Comparable)Boolean.valueOf(SlimeVineBlock.func_196542_b((IBlockReader)world, (BlockPos)up, (Direction)Direction.UP)));
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty prop = SlimeVineBlock.func_176267_a((Direction)direction);
            if (!((Boolean)state.func_177229_b((Property)prop)).booleanValue()) continue;
            state = (BlockState)state.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(this.hasAttachment(world, pos, direction)));
        }
        return state;
    }

    private boolean hasAttachment(IBlockReader world, BlockPos pos, Direction side) {
        if (side == Direction.DOWN) {
            return false;
        }
        BlockPos offset = pos.func_177972_a(side);
        if (SlimeVineBlock.func_196542_b((IBlockReader)world, (BlockPos)offset, (Direction)side)) {
            return true;
        }
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        if (upState.func_235714_a_(TinkerTags.Blocks.SLIMY_LEAVES)) {
            return true;
        }
        return side != Direction.UP && upState.func_203425_a((Block)this) && (Boolean)upState.func_177229_b((Property)field_196546_A.get(side)) != false && upState.func_177229_b(STAGE) != VineStage.END;
    }

    public static enum VineStage implements IStringSerializable
    {
        START,
        MIDDLE,
        END;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

