/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

public class SlimeTallGrassBlock
extends BushBlock
implements IForgeShearable {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final SlimeGrassBlock.FoliageType foliageType;
    private final SlimePlantType plantType;

    public SlimeTallGrassBlock(AbstractBlock.Properties properties, SlimeGrassBlock.FoliageType foliageType, SlimePlantType plantType) {
        super(properties);
        this.foliageType = foliageType;
        this.plantType = plantType;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XYZ;
    }

    @Nonnull
    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return TinkerWorld.SLIME_PLANT_TYPE;
    }

    public List<ItemStack> onSheared(@Nullable PlayerEntity player, ItemStack item, World world, BlockPos pos, int fortune) {
        ItemStack stack = new ItemStack((IItemProvider)this, 1);
        return Lists.newArrayList((Object[])new ItemStack[]{stack});
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return TinkerWorld.slimeDirt.contains((IForgeRegistryEntry)block) || TinkerWorld.vanillaSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.earthSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.skySlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.enderSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.ichorSlimeGrass.contains((IForgeRegistryEntry)block);
    }

    public SlimeGrassBlock.FoliageType getFoliageType() {
        return this.foliageType;
    }

    public SlimePlantType getPlantType() {
        return this.plantType;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.foliageType != SlimeGrassBlock.FoliageType.ICHOR) {
            super.func_149666_a(group, items);
        }
    }

    public static enum SlimePlantType implements IStringSerializable
    {
        TALL_GRASS,
        FERN;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

