/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

public class SlimeLeavesBlock
extends LeavesBlock {
    private final SlimeGrassBlock.FoliageType foliageType;

    public SlimeLeavesBlock(AbstractBlock.Properties properties, SlimeGrassBlock.FoliageType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = SlimeLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.func_177229_b((Property)field_208494_a) != i) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        worldIn.func_180501_a(pos, SlimeLeavesBlock.updateDistance(state, (IWorld)worldIn, pos), 3);
    }

    private static BlockState updateDistance(BlockState state, IWorld world, BlockPos pos) {
        int i = 7;
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            mutableBlockPos.func_189533_g((Vector3i)pos).func_189536_c(direction);
            i = Math.min(i, SlimeLeavesBlock.getDistance(world.func_180495_p((BlockPos)mutableBlockPos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.func_206870_a((Property)field_208494_a, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (TinkerTags.Blocks.SLIMY_LOGS.func_230235_a_((Object)neighbor.func_177230_c())) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof SlimeLeavesBlock ? (Integer)neighbor.func_177229_b((Property)field_208494_a) : 7;
    }

    public SlimeGrassBlock.FoliageType getFoliageType() {
        return this.foliageType;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return SlimeLeavesBlock.updateDistance((BlockState)this.func_176223_P().func_206870_a((Property)field_208495_b, (Comparable)Boolean.TRUE), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public boolean canBeReplacedByLeaves(BlockState state, IWorldReader world, BlockPos pos) {
        return this.isAir(state, (IBlockReader)world, pos) || state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_235714_a_(TinkerTags.Blocks.SLIMY_LEAVES);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.foliageType != SlimeGrassBlock.FoliageType.ICHOR) {
            super.func_149666_a(group, items);
        }
    }
}

