/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;

public class SlimeGrassBlock
extends SnowyDirtBlock
implements IGrowable {
    private final FoliageType foliageType;

    public SlimeGrassBlock(AbstractBlock.Properties properties, FoliageType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    public FoliageType getFoliageType() {
        return this.foliageType;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return world.func_180495_p(pos.func_177984_a()).isAir(world, pos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        BlockPos up = pos.func_177984_a();
        block0: for (int i = 0; i < 128; ++i) {
            BlockState plantState;
            BlockPos target = up;
            for (int j = 0; j < i / 16; ++j) {
                if (!world.func_180495_p((target = target.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_235714_a_(TinkerTags.Blocks.SLIMY_GRASS) || world.func_180495_p(target).func_235785_r_((IBlockReader)world, pos)) continue block0;
            }
            if (!world.func_175623_d(target) || !(plantState = rand.nextInt(8) == 0 ? ((SlimeTallGrassBlock)TinkerWorld.slimeFern.get((Enum)this.foliageType)).func_176223_P() : ((SlimeTallGrassBlock)TinkerWorld.slimeTallGrass.get((Enum)this.foliageType)).func_176223_P()).func_196955_c((IWorldReader)world, target)) continue;
            world.func_180501_a(target, plantState, 3);
        }
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.isAreaLoaded(pos, 3)) {
            return;
        }
        if (!SlimeGrassBlock.isValidPos(state, (IWorldReader)world, pos)) {
            world.func_175656_a(pos, SlimeGrassBlock.getDirtState(state));
        } else if (world.func_201696_r(pos.func_177984_a()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos newGrass = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState newState = this.getStateFromDirt(world.func_180495_p(newGrass));
                if (newState == null || !SlimeGrassBlock.canSpread(newState, (IWorldReader)world, newGrass)) continue;
                world.func_175656_a(newGrass, (BlockState)newState.func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(world.func_180495_p(newGrass.func_177984_a()).func_203425_a(Blocks.field_150433_aE))));
            }
        }
    }

    private static boolean isValidPos(BlockState targetState, IWorldReader world, BlockPos pos) {
        BlockPos above = pos.func_177984_a();
        BlockState aboveState = world.func_180495_p(above);
        if (aboveState.func_203425_a(Blocks.field_150433_aE) && (Integer)aboveState.func_177229_b((Property)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        if (aboveState.func_204520_s().func_206882_g() == 8) {
            return false;
        }
        return LightEngine.func_215613_a((IBlockReader)world, (BlockState)targetState, (BlockPos)pos, (BlockState)aboveState, (BlockPos)above, (Direction)Direction.UP, (int)aboveState.func_200016_a((IBlockReader)world, above)) < world.func_201572_C();
    }

    private static boolean canSpread(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos above = pos.func_177984_a();
        return SlimeGrassBlock.isValidPos(state, world, pos) && !world.func_204610_c(above).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static BlockState getDirtState(BlockState grassState) {
        Block block = grassState.func_177230_c();
        for (SlimeType type : SlimeType.values()) {
            if (!TinkerWorld.slimeGrass.get((Object)type).contains((IForgeRegistryEntry)block)) continue;
            return ((Block)TinkerWorld.allDirt.get((Enum)type)).func_176223_P();
        }
        return Blocks.field_150346_d.func_176223_P();
    }

    @Nullable
    private BlockState getStateFromDirt(BlockState dirtState) {
        Block block = dirtState.func_177230_c();
        for (SlimeType type : SlimeType.values()) {
            if (TinkerWorld.allDirt.get((Enum)type) != block) continue;
            return ((SlimeGrassBlock)TinkerWorld.slimeGrass.get((Object)type).get((Enum)this.foliageType)).func_176223_P();
        }
        return null;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.foliageType != FoliageType.ICHOR) {
            super.func_149666_a(group, items);
        }
    }

    public static enum FoliageType implements IStringSerializable
    {
        SKY(62682),
        ICHOR(13670400),
        ENDER(11087359),
        BLOOD(0xB80000);

        @Deprecated
        public static FoliageType[] ORIGINAL;
        private final int defaultColor;

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        private FoliageType(int defaultColor) {
            this.defaultColor = defaultColor;
        }

        public int getDefaultColor() {
            return this.defaultColor;
        }

        static {
            ORIGINAL = new FoliageType[]{SKY, ICHOR, ENDER};
        }
    }
}

