/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEvents {
    private static boolean foundField = false;
    private static Field lootEntries = null;

    @SubscribeEvent
    static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (event.getCategory() == Biome.Category.NETHER) {
            if (((Boolean)Config.COMMON.generateSlimeIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.NETHER_SLIME_ISLAND);
            }
            if (((Boolean)Config.COMMON.generateCobalt.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, TinkerWorld.COBALT_ORE_FEATURE_SMALL);
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, TinkerWorld.COBALT_ORE_FEATURE_LARGE);
            }
        } else if (event.getCategory() != Biome.Category.THEEND) {
            if (((Boolean)Config.COMMON.generateSlimeIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.SLIME_ISLAND);
                event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TinkerWorld.skySlimeEntity.get(), 15, 2, 4));
            }
            if (((Boolean)Config.COMMON.generateCopper.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, TinkerWorld.COPPER_ORE_FEATURE);
            }
        } else if (event.getCategory() == Biome.Category.THEEND && WorldEvents.doesNameMatchBiomes(event.getName(), Biomes.field_201937_Q, Biomes.field_201938_R, Biomes.field_201939_S, Biomes.field_201936_P) && ((Boolean)Config.COMMON.generateSlimeIslands.get()).booleanValue()) {
            generation.func_242516_a(TinkerStructures.END_SLIME_ISLAND);
        }
    }

    private static boolean doesNameMatchBiomes(@Nullable ResourceLocation name, RegistryKey<?> ... biomes) {
        for (RegistryKey<?> biome : biomes) {
            if (!biome.func_240901_a_().equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    private static void addEntry(LootPool pool, LootEntry entry) {
        if (!foundField) {
            try {
                lootEntries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
                lootEntries.setAccessible(true);
                foundField = true;
            }
            catch (ObfuscationReflectionHelper.UnableToFindFieldException ex) {
                TConstruct.log.error("Failed to find field", (Throwable)ex);
                foundField = true;
                return;
            }
        }
        try {
            Object field = lootEntries.get(pool);
            if (field instanceof List) {
                List entries = (List)field;
                entries.add(entry);
            }
        }
        catch (ClassCastException | IllegalAccessException ex) {
            TConstruct.log.error("Failed to access field", (Throwable)ex);
            lootEntries = null;
        }
    }

    private static void injectInto(LootTableLoadEvent event, String tableName, String poolName, Supplier<LootEntry> entry) {
        LootPool pool;
        ResourceLocation name = event.getName();
        if ("minecraft".equals(name.func_110624_b()) && tableName.equals(name.func_110623_a()) && (pool = event.getTable().getPool(poolName)) != null) {
            WorldEvents.addEntry(pool, entry.get());
        }
    }

    @SubscribeEvent
    static void onLootTableLoad(LootTableLoadEvent event) {
        BiFunction<SlimeGrassBlock.FoliageType, Integer, LootEntry> makeSeed = (type, weight) -> ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerWorld.slimeGrassSeeds.get((Enum)type))).func_216086_a(weight.intValue()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(2.0f, 4.0f))).func_216081_b();
        BiFunction<SlimeGrassBlock.FoliageType, Integer, LootEntry> makeSapling = (type, weight) -> ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerWorld.slimeSapling.get((Enum)type))).func_216086_a(weight.intValue()).func_216081_b();
        WorldEvents.injectInto(event, "chests/simple_dungeon", "pool1", () -> (LootEntry)makeSeed.apply(SlimeGrassBlock.FoliageType.SKY, 10));
        WorldEvents.injectInto(event, "chests/simple_dungeon", "main", () -> (LootEntry)makeSapling.apply(SlimeGrassBlock.FoliageType.SKY, 10));
        WorldEvents.injectInto(event, "chests/nether_bridge", "main", () -> (LootEntry)makeSeed.apply(SlimeGrassBlock.FoliageType.BLOOD, 5));
        WorldEvents.injectInto(event, "chests/bastion_bridge", "pool2", () -> (LootEntry)makeSapling.apply(SlimeGrassBlock.FoliageType.BLOOD, 1));
        WorldEvents.injectInto(event, "chests/end_city_treasure", "main", () -> (LootEntry)makeSeed.apply(SlimeGrassBlock.FoliageType.ENDER, 5));
        WorldEvents.injectInto(event, "chests/end_city_treasure", "main", () -> (LootEntry)makeSapling.apply(SlimeGrassBlock.FoliageType.ENDER, 3));
    }
}

