/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.SlimeBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.util.SupplierItemGroup;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.registration.WoodBlockObject;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.block.BloodSlimeBlock;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.SlimeDirtBlock;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;
import slimeknights.tconstruct.world.block.SlimeLeavesBlock;
import slimeknights.tconstruct.world.block.SlimeSaplingBlock;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.block.StickySlimeBlock;
import slimeknights.tconstruct.world.data.WorldRecipeProvider;
import slimeknights.tconstruct.world.entity.BlueSlimeEntity;
import slimeknights.tconstruct.world.item.SlimeGrassSeedItem;
import slimeknights.tconstruct.world.worldgen.trees.SlimeTree;

public final class TinkerWorld
extends TinkerModule {
    public static final ItemGroup TAB_WORLD = new SupplierItemGroup("tconstruct", "world", () -> new ItemStack(cobaltOre));
    static final Logger log = Util.getLogger("tinker_world");
    public static final PlantType SLIME_PLANT_TYPE = PlantType.get((String)"slime");
    private static final Item.Properties WORLD_PROPS = new Item.Properties().func_200916_a(TAB_WORLD);
    private static final Function<Block, ? extends BlockItem> DEFAULT_BLOCK_ITEM = b -> new BlockItem(b, WORLD_PROPS);
    private static final Function<Block, ? extends BlockItem> TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, WORLD_PROPS);
    private static final AbstractBlock.Properties NETHER_ORE = TinkerWorld.builder(Material.field_151576_e, ToolType.PICKAXE, SoundType.field_235592_N_).func_235861_h_().harvestLevel(3).func_200943_b(10.0f).func_226896_b_();
    public static final ItemObject<Block> cobaltOre = BLOCKS.register("cobalt_ore", () -> new Block(NETHER_ORE), DEFAULT_BLOCK_ITEM);
    private static final AbstractBlock.Properties OVERWORLD_ORE = TinkerWorld.builder(Material.field_151576_e, ToolType.PICKAXE, SoundType.field_185851_d).func_235861_h_().harvestLevel(1).func_200948_a(3.0f, 3.0f);
    public static final ItemObject<Block> copperOre = BLOCKS.register("copper_ore", OVERWORLD_ORE, DEFAULT_BLOCK_ITEM);
    private static final AbstractBlock.Properties SLIME = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180399_cE);
    public static final EnumObject<SlimeType, SlimeBlock> slime = new EnumObject.Builder(SlimeType.class).putDelegate((Enum)SlimeType.EARTH, Blocks.field_180399_cE.delegate).put((Enum)SlimeType.SKY, (Supplier)BLOCKS.register("sky_slime", () -> new StickySlimeBlock(SLIME, (state, other) -> true), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ICHOR, (Supplier)BLOCKS.register("ichor_slime", () -> new StickySlimeBlock(SLIME, (state, other) -> other.func_177230_c() != state.func_177230_c()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ENDER, (Supplier)BLOCKS.register("ender_slime", () -> new StickySlimeBlock(SLIME, (state, other) -> other.func_177230_c() == state.func_177230_c()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.BLOOD, (Supplier)BLOCKS.register("blood_slime", () -> new BloodSlimeBlock(SLIME), TOOLTIP_BLOCK_ITEM)).build();
    private static final AbstractBlock.Properties CONGEALED_SLIME = TinkerWorld.builder(Material.field_151571_B, ToolType.SHOVEL, SoundType.field_185859_l).func_200943_b(0.5f).func_200941_a(0.5f);
    public static final EnumObject<SlimeType, CongealedSlimeBlock> congealedSlime = BLOCKS.registerEnum(SlimeType.values(), "congealed_slime", type -> new CongealedSlimeBlock(CONGEALED_SLIME), TOOLTIP_BLOCK_ITEM);
    private static final AbstractBlock.Properties SLIME_DIRT = TinkerWorld.builder(Material.field_151578_c, ToolType.SHOVEL, SoundType.field_185859_l).func_200943_b(0.55f);
    private static final AbstractBlock.Properties SLIME_GRASS = TinkerWorld.builder(Material.field_151577_b, ToolType.SHOVEL, SoundType.field_185859_l).func_200943_b(0.65f).func_200944_c();
    public static final EnumObject<SlimeType, Block> slimeDirt = BLOCKS.registerEnum(SlimeType.TRUE_SLIME, "slime_dirt", type -> new SlimeDirtBlock(SLIME_DIRT), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeType, Block> allDirt = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.BLOOD, (Supplier)Blocks.field_150346_d.delegate).putAll(slimeDirt).build();
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeGrassBlock> vanillaSlimeGrass = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "vanilla_slime_grass", type -> new SlimeGrassBlock(SLIME_GRASS, (SlimeGrassBlock.FoliageType)((Object)type)), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeGrassBlock> earthSlimeGrass = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "earth_slime_grass", type -> new SlimeGrassBlock(SLIME_GRASS, (SlimeGrassBlock.FoliageType)((Object)type)), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeGrassBlock> skySlimeGrass = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "sky_slime_grass", type -> new SlimeGrassBlock(SLIME_GRASS, (SlimeGrassBlock.FoliageType)((Object)type)), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeGrassBlock> enderSlimeGrass = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "ender_slime_grass", type -> new SlimeGrassBlock(SLIME_GRASS, (SlimeGrassBlock.FoliageType)((Object)type)), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeGrassBlock> ichorSlimeGrass = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "ichor_slime_grass", type -> new SlimeGrassBlock(SLIME_GRASS, (SlimeGrassBlock.FoliageType)((Object)type)), TOOLTIP_BLOCK_ITEM);
    public static final Map<SlimeType, EnumObject<SlimeGrassBlock.FoliageType, SlimeGrassBlock>> slimeGrass = new EnumMap<SlimeType, EnumObject<SlimeGrassBlock.FoliageType, SlimeGrassBlock>>(SlimeType.class);
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeGrassSeedItem> slimeGrassSeeds;
    private static final AbstractBlock.Properties GRASS;
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeTallGrassBlock> slimeFern;
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeTallGrassBlock> slimeTallGrass;
    public static final Material SLIME_WOOD;
    public static final WoodBlockObject greenheart;
    public static final WoodBlockObject skyroot;
    public static final WoodBlockObject bloodshroom;
    private static final AbstractBlock.Properties SAPLING;
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeSaplingBlock> slimeSapling;
    private static final AbstractBlock.Properties SLIME_LEAVES;
    private static final AbstractBlock.Properties SLIME_WART;
    public static final EnumObject<SlimeGrassBlock.FoliageType, SlimeLeavesBlock> slimeLeaves;
    private static final AbstractBlock.Properties VINE;
    public static final ItemObject<SlimeVineBlock> enderSlimeVine;
    public static final ItemObject<SlimeVineBlock> skySlimeVine;
    public static final RegistryObject<EntityType<BlueSlimeEntity>> skySlimeEntity;
    public static final RegistryObject<BasicParticleType> slimeParticle;
    public static ConfiguredFeature<?, ?> COPPER_ORE_FEATURE;
    public static ConfiguredFeature<?, ?> COBALT_ORE_FEATURE_SMALL;
    public static ConfiguredFeature<?, ?> COBALT_ORE_FEATURE_LARGE;

    @SubscribeEvent
    void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)skySlimeEntity.get(), MonsterEntity.func_234295_eP_().func_233813_a_());
    }

    private static void setWoodFireInfo(FireBlock fireBlock, WoodBlockObject wood) {
        fireBlock.func_180686_a((Block)wood.get(), 5, 20);
        fireBlock.func_180686_a((Block)wood.getSlab(), 5, 20);
        fireBlock.func_180686_a((Block)wood.getStairs(), 5, 20);
        fireBlock.func_180686_a((Block)wood.getFence(), 5, 20);
        fireBlock.func_180686_a((Block)wood.getFenceGate(), 5, 20);
        fireBlock.func_180686_a(wood.getLog(), 5, 5);
        fireBlock.func_180686_a(wood.getStrippedLog(), 5, 5);
        fireBlock.func_180686_a(wood.getWood(), 5, 5);
        fireBlock.func_180686_a(wood.getStrippedWood(), 5, 5);
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)skySlimeEntity.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.WORLD_SURFACE, BlueSlimeEntity::canSpawnHere);
        event.enqueueWork(() -> {
            slimeLeaves.forEach(block -> ComposterBlock.func_220290_a((float)0.35f, (IItemProvider)block));
            slimeSapling.forEach(block -> ComposterBlock.func_220290_a((float)0.35f, (IItemProvider)block));
            slimeTallGrass.forEach(block -> ComposterBlock.func_220290_a((float)0.35f, (IItemProvider)block));
            slimeFern.forEach(block -> ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)block));
            slimeGrassSeeds.forEach(block -> ComposterBlock.func_220290_a((float)0.35f, (IItemProvider)block));
            ComposterBlock.func_220290_a((float)0.5f, skySlimeVine);
            ComposterBlock.func_220290_a((float)0.5f, enderSlimeVine);
        });
        event.enqueueWork(() -> {
            FireBlock fireblock = (FireBlock)Blocks.field_150480_ab;
            TinkerWorld.setWoodFireInfo(fireblock, greenheart);
            TinkerWorld.setWoodFireInfo(fireblock, skyroot);
            BiConsumer<SlimeGrassBlock.FoliageType, Block> plantFireInfo = (type, block) -> {
                if (type != SlimeGrassBlock.FoliageType.BLOOD && type != SlimeGrassBlock.FoliageType.ICHOR) {
                    fireblock.func_180686_a(block, 30, 60);
                }
            };
            slimeLeaves.forEach(plantFireInfo);
            slimeTallGrass.forEach(plantFireInfo);
            slimeFern.forEach(plantFireInfo);
            fireblock.func_180686_a((Block)skySlimeVine.get(), 15, 100);
            fireblock.func_180686_a((Block)enderSlimeVine.get(), 15, 100);
        });
        COPPER_ORE_FEATURE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerWorld.location("copper_ore"), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)copperOre.get()).func_176223_P(), 9)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(40, 0, 60))).func_242728_a()).func_242731_b(((Integer)Config.COMMON.veinCountCopper.get()).intValue()));
        COBALT_ORE_FEATURE_SMALL = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerWorld.location("cobalt_ore_small"), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)cobaltOre.get()).func_176223_P(), 4)).func_227228_a_(Features.Placements.field_243998_i).func_242728_a()).func_242731_b((Integer)Config.COMMON.veinCountCobalt.get() / 2));
        COBALT_ORE_FEATURE_LARGE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerWorld.location("cobalt_ore_large"), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)cobaltOre.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(32, 16))).func_242728_a()).func_242731_b((Integer)Config.COMMON.veinCountCobalt.get() / 2));
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.func_200390_a((IDataProvider)new WorldRecipeProvider(datagenerator));
        }
    }

    static {
        slimeGrass.put(SlimeType.BLOOD, vanillaSlimeGrass);
        slimeGrass.put(SlimeType.EARTH, earthSlimeGrass);
        slimeGrass.put(SlimeType.SKY, skySlimeGrass);
        slimeGrass.put(SlimeType.ENDER, enderSlimeGrass);
        slimeGrass.put(SlimeType.ICHOR, ichorSlimeGrass);
        slimeGrassSeeds = ITEMS.registerEnum(SlimeGrassBlock.FoliageType.values(), "slime_grass_seeds", type -> new SlimeGrassSeedItem(WORLD_PROPS, (SlimeGrassBlock.FoliageType)((Object)type)));
        GRASS = TinkerWorld.builder(Material.field_151585_k, NO_TOOL, SoundType.field_185850_c).func_200946_b().func_200942_a().func_200944_c();
        slimeFern = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "slime_fern", type -> new SlimeTallGrassBlock(GRASS, (SlimeGrassBlock.FoliageType)((Object)type), SlimeTallGrassBlock.SlimePlantType.FERN), DEFAULT_BLOCK_ITEM);
        slimeTallGrass = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "slime_tall_grass", type -> new SlimeTallGrassBlock(GRASS, (SlimeGrassBlock.FoliageType)((Object)type), SlimeTallGrassBlock.SlimePlantType.TALL_GRASS), DEFAULT_BLOCK_ITEM);
        SLIME_WOOD = new Material.Builder(MaterialColor.field_151667_k).func_200504_e().func_200506_i();
        greenheart = BLOCKS.registerWood("greenheart", SLIME_WOOD, MaterialColor.field_151672_u, SoundType.field_185859_l, ToolType.SHOVEL, Material.field_151575_d, MaterialColor.field_151651_C, SoundType.field_185848_a, TAB_WORLD);
        skyroot = BLOCKS.registerWood("skyroot", SLIME_WOOD, MaterialColor.field_151679_y, SoundType.field_185859_l, ToolType.SHOVEL, Material.field_151575_d, MaterialColor.field_193570_V, SoundType.field_185848_a, TAB_WORLD);
        bloodshroom = BLOCKS.registerWood("bloodshroom", Material.field_151571_B, MaterialColor.field_151645_D, SoundType.field_185859_l, ToolType.SHOVEL, Material.field_237214_y_, MaterialColor.field_151676_q, SoundType.field_235602_z_, TAB_WORLD);
        SAPLING = TinkerWorld.builder(Material.field_151585_k, NO_TOOL, SoundType.field_185850_c).func_200946_b().func_200942_a().func_200944_c();
        slimeSapling = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "slime_sapling", type -> new SlimeSaplingBlock(new SlimeTree((SlimeGrassBlock.FoliageType)((Object)type)), (SlimeGrassBlock.FoliageType)((Object)type), SAPLING), TOOLTIP_BLOCK_ITEM);
        SLIME_LEAVES = TinkerWorld.builder(Material.field_151584_j, NO_TOOL, SoundType.field_185850_c).func_200943_b(0.3f).func_200944_c().func_226896_b_().func_235827_a_((s, w, p, e) -> false);
        SLIME_WART = TinkerWorld.builder(Material.field_151577_b, NO_TOOL, SoundType.field_235588_J_).func_200943_b(0.6f).func_200944_c().func_235827_a_((s, w, p, e) -> false);
        slimeLeaves = BLOCKS.registerEnum(SlimeGrassBlock.FoliageType.values(), "slime_leaves", type -> new SlimeLeavesBlock(type == SlimeGrassBlock.FoliageType.BLOOD ? SLIME_WART : SLIME_LEAVES, (SlimeGrassBlock.FoliageType)((Object)type)), DEFAULT_BLOCK_ITEM);
        VINE = TinkerWorld.builder(Material.field_151582_l, NO_TOOL, SoundType.field_185850_c).func_200943_b(0.3f).func_200942_a().func_200944_c();
        enderSlimeVine = BLOCKS.register("ender_slime_vine", () -> new SlimeVineBlock(VINE, SlimeGrassBlock.FoliageType.ENDER), DEFAULT_BLOCK_ITEM);
        skySlimeVine = BLOCKS.register("sky_slime_vine", () -> new SlimeVineBlock(VINE, SlimeGrassBlock.FoliageType.SKY), DEFAULT_BLOCK_ITEM);
        skySlimeEntity = ENTITIES.registerWithEgg("sky_slime", () -> EntityType.Builder.func_220322_a(BlueSlimeEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setUpdateInterval(5).setTrackingRange(64).func_220321_a(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (BlueSlimeEntity)((EntityType)skySlimeEntity.get()).func_200721_a(world)), 4714485, 11337716);
        slimeParticle = PARTICLE_TYPES.register("slime", () -> new BasicParticleType(false));
    }
}

