/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;
import slimeknights.tconstruct.world.block.SlimeLeavesBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.SlimeIslandPiece;
import slimeknights.tconstruct.world.worldgen.islands.end.EndSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.nether.NetherSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.overworld.OverworldSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.trees.SupplierBlockStateProvider;
import slimeknights.tconstruct.world.worldgen.trees.config.BaseSlimeTreeFeatureConfig;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeTreeFeature;

public final class TinkerStructures
extends TinkerModule {
    static final Logger log = Util.getLogger("tinker_structures");
    public static final RegistryObject<BlockStateProviderType<SupplierBlockStateProvider>> supplierBlockstateProvider = BLOCK_STATE_PROVIDER_TYPES.register("supplier_state_provider", () -> new BlockStateProviderType(SupplierBlockStateProvider.CODEC));
    public static final RegistryObject<Feature<BaseSlimeTreeFeatureConfig>> SLIME_TREE = FEATURES.register("slime_tree", () -> new SlimeTreeFeature(BaseSlimeTreeFeatureConfig.CODEC));
    public static ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> SKY_SLIME_TREE;
    public static ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> SKY_SLIME_ISLAND_TREE;
    public static ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> ENDER_SLIME_TREE;
    public static ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> ENDER_SLIME_ISLAND_TREE;
    public static ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> BLOOD_SLIME_TREE;
    public static ConfiguredFeature<BaseSlimeTreeFeatureConfig, ?> ICHOR_SLIME_TREE;
    public static IStructurePieceType slimeIslandPiece;
    public static final RegistryObject<Structure<NoFeatureConfig>> overworldSlimeIsland;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> SLIME_ISLAND;
    public static final RegistryObject<Structure<NoFeatureConfig>> netherSlimeIsland;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> NETHER_SLIME_ISLAND;
    public static final RegistryObject<Structure<NoFeatureConfig>> endSlimeIsland;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> END_SLIME_ISLAND;

    @SubscribeEvent
    void onFeaturesRegistry(RegistryEvent.Register<Feature<?>> event) {
        slimeIslandPiece = (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)TinkerStructures.location("slime_island_piece"), SlimeIslandPiece::new);
    }

    private static void addStructureSettings(RegistryKey<DimensionSettings> key, Structure<?> structure, StructureSeparationSettings settings) {
        DimensionSettings dimensionSettings = (DimensionSettings)WorldGenRegistries.field_243658_j.func_230516_a_(key);
        if (dimensionSettings != null) {
            dimensionSettings.func_236108_a_().func_236195_a_().put(structure, settings);
        }
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        SLIME_ISLAND = (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)TinkerStructures.location("overworld_slime_island"), (Object)((Structure)overworldSlimeIsland.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
        Structure.field_236365_a_.put((Object)"tconstruct:overworld_slime_island", (Object)overworldSlimeIsland.get());
        StructureSeparationSettings overworldSettings = new StructureSeparationSettings(30, 22, 14357800);
        DimensionSettings.func_242746_i().func_236108_a_().func_236195_a_().put(overworldSlimeIsland.get(), overworldSettings);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242735_d, (Structure)overworldSlimeIsland.get(), overworldSettings);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242739_h, (Structure)overworldSlimeIsland.get(), overworldSettings);
        NETHER_SLIME_ISLAND = (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)TinkerStructures.location("nether_slime_island"), (Object)((Structure)netherSlimeIsland.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
        Structure.field_236365_a_.put((Object)"tconstruct:nether_slime_island", (Object)netherSlimeIsland.get());
        StructureSeparationSettings netherSettings = new StructureSeparationSettings(15, 11, 65245622);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242736_e, (Structure)netherSlimeIsland.get(), netherSettings);
        END_SLIME_ISLAND = (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)TinkerStructures.location("end_slime_island"), (Object)((Structure)endSlimeIsland.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
        Structure.field_236365_a_.put((Object)"tconstruct:end_slime_island", (Object)endSlimeIsland.get());
        StructureSeparationSettings endSettings = new StructureSeparationSettings(15, 11, 65245622);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242737_f, (Structure)endSlimeIsland.get(), endSettings);
        event.enqueueWork(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll((Map)DimensionStructuresSettings.field_236191_b_);
            builder.put((Object)overworldSlimeIsland.get(), (Object)overworldSettings);
            builder.put((Object)netherSlimeIsland.get(), (Object)netherSettings);
            builder.put((Object)endSlimeIsland.get(), (Object)endSettings);
            DimensionStructuresSettings.field_236191_b_ = builder.build();
        });
        SKY_SLIME_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.location("sky_slime_tree"), (Object)((Feature)SLIME_TREE.get()).func_225566_b_((IFeatureConfig)new BaseSlimeTreeFeatureConfig.Builder(new SupplierBlockStateProvider(() -> TinkerWorld.skyroot.getLog().func_176223_P()), new SupplierBlockStateProvider(() -> ((SlimeLeavesBlock)TinkerWorld.slimeLeaves.get((Enum)SlimeGrassBlock.FoliageType.SKY)).func_176223_P()), new SupplierBlockStateProvider(() -> ((Block)Blocks.field_150350_a).func_176223_P()), 5, 4, false).build()));
        SKY_SLIME_ISLAND_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.location("sky_slime_island_tree"), (Object)((Feature)SLIME_TREE.get()).func_225566_b_((IFeatureConfig)new BaseSlimeTreeFeatureConfig.Builder(new SupplierBlockStateProvider(() -> TinkerWorld.skyroot.getLog().func_176223_P()), new SupplierBlockStateProvider(() -> ((SlimeLeavesBlock)TinkerWorld.slimeLeaves.get((Enum)SlimeGrassBlock.FoliageType.SKY)).func_176223_P()), new SupplierBlockStateProvider(() -> (BlockState)((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).func_176223_P().func_206870_a(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))), 5, 4, true).build()));
        ENDER_SLIME_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.location("ender_slime_tree"), (Object)((Feature)SLIME_TREE.get()).func_225566_b_((IFeatureConfig)new BaseSlimeTreeFeatureConfig.Builder(new SupplierBlockStateProvider(() -> TinkerWorld.greenheart.getLog().func_176223_P()), new SupplierBlockStateProvider(() -> ((SlimeLeavesBlock)TinkerWorld.slimeLeaves.get((Enum)SlimeGrassBlock.FoliageType.ENDER)).func_176223_P()), new SupplierBlockStateProvider(() -> ((Block)Blocks.field_150350_a).func_176223_P()), 5, 4, false).build()));
        ENDER_SLIME_ISLAND_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.location("ender_slime_island_tree"), (Object)((Feature)SLIME_TREE.get()).func_225566_b_((IFeatureConfig)new BaseSlimeTreeFeatureConfig.Builder(new SupplierBlockStateProvider(() -> TinkerWorld.greenheart.getLog().func_176223_P()), new SupplierBlockStateProvider(() -> ((SlimeLeavesBlock)TinkerWorld.slimeLeaves.get((Enum)SlimeGrassBlock.FoliageType.ENDER)).func_176223_P()), new SupplierBlockStateProvider(() -> (BlockState)((SlimeVineBlock)TinkerWorld.enderSlimeVine.get()).func_176223_P().func_206870_a(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))), 5, 4, true).build()));
        BLOOD_SLIME_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.location("blood_slime_tree"), (Object)((Feature)SLIME_TREE.get()).func_225566_b_((IFeatureConfig)new BaseSlimeTreeFeatureConfig.Builder(new SupplierBlockStateProvider(() -> TinkerWorld.bloodshroom.getLog().func_176223_P()), new SupplierBlockStateProvider(() -> ((SlimeLeavesBlock)TinkerWorld.slimeLeaves.get((Enum)SlimeGrassBlock.FoliageType.BLOOD)).func_176223_P()), new SupplierBlockStateProvider(() -> ((Block)Blocks.field_150350_a).func_176223_P()), 5, 4, false).build()));
        ICHOR_SLIME_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.location("ichor_slime_tree"), (Object)((Feature)SLIME_TREE.get()).func_225566_b_((IFeatureConfig)new BaseSlimeTreeFeatureConfig.Builder(new SupplierBlockStateProvider(() -> TinkerWorld.bloodshroom.getLog().func_176223_P()), new SupplierBlockStateProvider(() -> ((SlimeLeavesBlock)TinkerWorld.slimeLeaves.get((Enum)SlimeGrassBlock.FoliageType.ICHOR)).func_176223_P()), new SupplierBlockStateProvider(() -> ((Block)Blocks.field_150350_a).func_176223_P()), 5, 4, false).build()));
    }

    static {
        overworldSlimeIsland = STRUCTURE_FEATURES.register("overworld_slime_island", () -> new OverworldSlimeIslandStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        netherSlimeIsland = STRUCTURE_FEATURES.register("nether_slime_island", () -> new NetherSlimeIslandStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        endSlimeIsland = STRUCTURE_FEATURES.register("end_slime_island", () -> new EndSlimeIslandStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    }
}

