/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.renderer.font.CustomFontColor;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.HarvestLevels;

public class HeadMaterialStats
extends BaseMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(Util.getResource("head"));
    public static final HeadMaterialStats DEFAULT = new HeadMaterialStats(1, 1.0f, 0, 1.0f);
    public static final String DURABILITY_PREFIX = HeadMaterialStats.makeTooltipKey("head.durability");
    private static final String MINING_SPEED_PREFIX = HeadMaterialStats.makeTooltipKey("head.mining_speed");
    private static final String ATTACK_PREFIX = HeadMaterialStats.makeTooltipKey("head.attack");
    private static final String HARVEST_LEVEL_PREFIX = HeadMaterialStats.makeTooltipKey("head.harvest_level");
    private static final ITextComponent DURABILITY_DESCRIPTION = HeadMaterialStats.makeTooltip("head.durability.description");
    private static final ITextComponent MINING_SPEED_DESCRIPTION = HeadMaterialStats.makeTooltip("head.mining_speed.description");
    private static final ITextComponent ATTACK_DESCRIPTION = HeadMaterialStats.makeTooltip("head.attack.description");
    private static final ITextComponent HARVEST_LEVEL_DESCRIPTION = HeadMaterialStats.makeTooltip("head.harvest_level.description");
    private static final List<ITextComponent> DESCRIPTION = ImmutableList.of((Object)DURABILITY_DESCRIPTION, (Object)HARVEST_LEVEL_DESCRIPTION, (Object)MINING_SPEED_DESCRIPTION, (Object)ATTACK_DESCRIPTION);
    private static final ITextComponent TOOLTIP_BROKEN = Util.makeTranslation("tooltip", "tool.broken").func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.DARK_RED});
    private static final ITextComponent TOOLTIP_BROKEN_PREFIXED = new TranslationTextComponent(DURABILITY_PREFIX).func_230529_a_(TOOLTIP_BROKEN);
    public static final Color DURABILITY_COLOR = Color.func_240743_a_((int)-12071865);
    public static final Color MINING_SPEED_COLOR = Color.func_240743_a_((int)-8871731);
    public static final Color ATTACK_COLOR = Color.func_240743_a_((int)-2661276);
    private int durability;
    private float miningSpeed;
    private int harvestLevel;
    private float attack;

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.durability);
        buffer.writeFloat(this.miningSpeed);
        buffer.writeInt(this.harvestLevel);
        buffer.writeFloat(this.attack);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.durability = buffer.readInt();
        this.miningSpeed = buffer.readFloat();
        this.harvestLevel = buffer.readInt();
        this.attack = buffer.readFloat();
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<ITextComponent> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(HeadMaterialStats.formatDurability(this.durability));
        info.add(HeadMaterialStats.formatHarvestLevel(this.harvestLevel));
        info.add(HeadMaterialStats.formatMiningSpeed(this.miningSpeed));
        info.add(HeadMaterialStats.formatAttack(this.attack));
        return info;
    }

    @Override
    public List<ITextComponent> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public static ITextComponent formatDurability(int durability) {
        return HeadMaterialStats.formatNumber(DURABILITY_PREFIX, DURABILITY_COLOR, durability);
    }

    public static ITextComponent formatDurability(int durability, int ref, boolean textIfBroken) {
        if (textIfBroken && durability == 0) {
            return TOOLTIP_BROKEN_PREFIXED;
        }
        return new TranslationTextComponent(DURABILITY_PREFIX).func_230529_a_(CustomFontColor.formatPartialAmount(durability, ref));
    }

    public static ITextComponent formatHarvestLevel(int level) {
        return new TranslationTextComponent(HARVEST_LEVEL_PREFIX).func_230529_a_(HarvestLevels.getHarvestLevelName(level));
    }

    public static ITextComponent formatMiningSpeed(float speed) {
        return HeadMaterialStats.formatNumber(MINING_SPEED_PREFIX, MINING_SPEED_COLOR, speed);
    }

    public static ITextComponent formatAttack(float attack) {
        return HeadMaterialStats.formatNumber(ATTACK_PREFIX, ATTACK_COLOR, attack);
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getAttack() {
        return this.attack;
    }

    public HeadMaterialStats() {
    }

    public HeadMaterialStats(int durability, float miningSpeed, int harvestLevel, float attack) {
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.harvestLevel = harvestLevel;
        this.attack = attack;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeadMaterialStats)) {
            return false;
        }
        HeadMaterialStats other = (HeadMaterialStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDurability() != other.getDurability()) {
            return false;
        }
        if (Float.compare(this.getMiningSpeed(), other.getMiningSpeed()) != 0) {
            return false;
        }
        if (this.getHarvestLevel() != other.getHarvestLevel()) {
            return false;
        }
        return Float.compare(this.getAttack(), other.getAttack()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HeadMaterialStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDurability();
        result = result * 59 + Float.floatToIntBits(this.getMiningSpeed());
        result = result * 59 + this.getHarvestLevel();
        result = result * 59 + Float.floatToIntBits(this.getAttack());
        return result;
    }

    public String toString() {
        return "HeadMaterialStats(durability=" + this.getDurability() + ", miningSpeed=" + this.getMiningSpeed() + ", harvestLevel=" + this.getHarvestLevel() + ", attack=" + this.getAttack() + ")";
    }
}

