/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.TankModifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SearingModifier
extends Modifier {
    private static final float BASELINE_TEMPERATURE = 0.75f;

    public SearingModifier() {
        super(0x3F3F3F);
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        ((TankModifier)TinkerModifiers.tank.get()).addCapacity(volatileData, 288);
    }

    private static float temperatureBoost(float temperature, int level) {
        return (temperature - 0.75f) * (float)(level * 2);
    }

    @Override
    public float applyLivingDamage(IModifierToolStack tool, int level, LivingEntity attacker, LivingEntity target, float baseDamage, float damage, boolean isCritical, boolean fullyCharged) {
        BlockPos attackerPos = attacker.func_233580_cy_();
        float temperature = attacker.field_70170_p.func_226691_t_(attackerPos).func_225486_c(attackerPos);
        if (temperature < 0.75f) {
            damage += SearingModifier.temperatureBoost(temperature, level);
        }
        return damage;
    }

    @Override
    public int afterLivingHit(IModifierToolStack tool, int level, LivingEntity attacker, LivingEntity target, float damageDealt, boolean isCritical, boolean fullyCharged) {
        BlockPos attackerPos = attacker.func_233580_cy_();
        float temperature = attacker.field_70170_p.func_226691_t_(attackerPos).func_225486_c(attackerPos);
        if (temperature > 0.75f) {
            DamageSource source = attacker instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)) : DamageSource.func_76358_a((LivingEntity)attacker);
            target.field_70172_ad = 0;
            SearingModifier.attackEntitySecondary(source.func_76361_j(), SearingModifier.temperatureBoost(temperature, level), target, false);
        }
        return 0;
    }
}

