/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits;

import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.effect.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MomentumModifier
extends Modifier {
    public MomentumModifier() {
        super(6310251);
    }

    @Override
    public int getPriority() {
        return 75;
    }

    @Override
    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            int effectLevel = ((TinkerEffect)TinkerModifiers.momentumEffect.get()).getLevel(event.getEntityLiving()) + 1;
            event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)(level * effectLevel) / 64.0f));
        }
    }

    @Override
    public void afterBlockBreak(IModifierToolStack tool, int level, World world, BlockState state, BlockPos pos, LivingEntity living, boolean wasEffective) {
        if (wasEffective) {
            int effectLevel = Math.min(31, ((TinkerEffect)TinkerModifiers.momentumEffect.get()).getLevel(living) + 1);
            int duration = (int)(10.0f / tool.getStats().getMiningSpeed() * 1.5f * 20.0f);
            ((TinkerEffect)TinkerModifiers.momentumEffect.get()).apply(living, duration, effectLevel);
        }
    }
}

