/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits;

import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class MaintainedModifier
extends Modifier {
    private static final ITextComponent MINING_SPEED = Util.makeTranslation("modifier", "fake_attribute.mining_speed");
    private static final ResourceLocation KEY_ORIGINAL_DURABILITY = Util.getResource("durability");

    public MaintainedModifier() {
        super(14925160);
    }

    protected MaintainedModifier(int color) {
        super(color);
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        volatileData.putInt(KEY_ORIGINAL_DURABILITY, (int)((float)baseStats.getDurability() * toolDefinition.getBaseStatDefinition().getDurabilityModifier()));
    }

    public static float boost(int durability, float boost, int min, int max) {
        if (durability > min) {
            if (durability > max) {
                return boost;
            }
            return boost * (float)(durability - min) / (float)(max - min);
        }
        return 0.0f;
    }

    protected float getTotalBoost(IModifierToolStack tool, int level) {
        int durability = tool.getCurrentDurability();
        int baseMax = tool.getVolatileData().getInt(KEY_ORIGINAL_DURABILITY);
        float boost = MaintainedModifier.boost(durability, 0.1f, baseMax / 2, baseMax);
        int fullMax = tool.getStats().getDurability();
        if (fullMax > baseMax) {
            boost += MaintainedModifier.boost(durability, 0.05f, baseMax, Math.max(baseMax * 2, fullMax));
        }
        return boost * (float)level;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        double boost = this.getTotalBoost(tool, level);
        if (boost != 0.0) {
            tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent(Util.dfPercentBoost.format(boost)).func_240702_b_(" ").func_230529_a_(MINING_SPEED)));
        }
    }

    @Override
    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + this.getTotalBoost(tool, level)));
        }
    }
}

