/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.shared;

import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class ExtraModifier
extends Modifier {
    private final ExtraType type;
    private final ModifierSource source;
    private final int slotsPerLevel;

    public ExtraModifier(int color, ExtraType type, ModifierSource source, int slotsPerLevel) {
        super(color);
        this.type = type;
        this.source = source;
        this.slotsPerLevel = slotsPerLevel;
    }

    public ExtraModifier(int color, ExtraType type, ModifierSource source) {
        this(color, type, source, 1);
    }

    public ExtraModifier(int color) {
        this(color, ExtraType.UPGRADE, ModifierSource.SINGLE_USE);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.source.alwaysShow() || advanced;
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT data) {
        this.type.add(data, this.source.isSingleUse() ? this.slotsPerLevel : level * this.slotsPerLevel);
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        if (this.source.isSingleUse()) {
            return this.getDisplayName();
        }
        return super.getDisplayName(level);
    }

    @Override
    public int getPriority() {
        return this.source.isSingleUse() ? 50 : 75;
    }

    public static enum ExtraType {
        UPGRADE{

            @Override
            public void add(ModDataNBT data, int amount) {
                data.addUpgrades(amount);
            }
        }
        ,
        ABILITY{

            @Override
            public void add(ModDataNBT data, int amount) {
                data.addAbilities(amount);
            }
        }
        ,
        TRAIT{

            @Override
            public void add(ModDataNBT data, int amount) {
                data.addTraits(amount);
            }
        };


        public abstract void add(ModDataNBT var1, int var2);
    }

    public static enum ModifierSource {
        SINGLE_USE,
        MULTI_USE,
        TRAIT;


        public boolean isSingleUse() {
            return this == SINGLE_USE;
        }

        public boolean alwaysShow() {
            return this == TRAIT;
        }
    }
}

