/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.shared;

import net.minecraft.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ExperiencedModifier
extends Modifier {
    public ExperiencedModifier() {
        super(15260489);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityKill);
        MinecraftForge.EVENT_BUS.addListener(this::beforeBlockBreak);
    }

    private static int boost(int original, int level) {
        return (int)((double)original * (1.0 + 0.5 * (double)level));
    }

    private void beforeBlockBreak(BlockEvent.BreakEvent event) {
        int level;
        ToolStack tool = ExperiencedModifier.getHeldTool((LivingEntity)event.getPlayer());
        if (tool != null && (level = tool.getModifierLevel(this)) > 0) {
            event.setExpToDrop(ExperiencedModifier.boost(event.getExpToDrop(), level));
        }
    }

    private void onEntityKill(LivingExperienceDropEvent event) {
        int level;
        ToolStack tool = ExperiencedModifier.getHeldTool((LivingEntity)event.getAttackingPlayer());
        if (tool != null && (level = tool.getModifierLevel(this)) > 0) {
            event.setDroppedExperience(ExperiencedModifier.boost(event.getDroppedExperience(), level));
        }
    }
}

