/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability;

import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class ShearsAbilityModifier
extends SingleUseModifier {
    private final int priority;

    public ShearsAbilityModifier(int color, int priority) {
        super(color);
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    protected void swingTool(PlayerEntity player, Hand hand) {
        player.func_184609_a(hand);
        player.func_184810_cG();
    }

    protected boolean isShears(IModifierToolStack tool) {
        return true;
    }

    @Override
    public ActionResultType onEntityUse(IModifierToolStack tool, int level, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (this.isShears(tool) && target instanceof IForgeShearable) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            if (!tool.isBroken() && this.shearEntity(stack, playerIn.func_130014_f_(), playerIn, (Entity)target, fortune)) {
                ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)playerIn, hand);
                this.swingTool(playerIn, hand);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private boolean shearEntity(ItemStack itemStack, World world, PlayerEntity playerEntity, Entity entity, int fortune) {
        if (!(entity instanceof IForgeShearable)) {
            return false;
        }
        IForgeShearable target = (IForgeShearable)entity;
        if (target.isShearable(itemStack, world, entity.func_233580_cy_())) {
            if (!world.field_72995_K) {
                List drops = target.onSheared(playerEntity, itemStack, world, entity.func_233580_cy_(), fortune);
                Random rand = world.field_73012_v;
                drops.forEach(d -> {
                    ItemEntity ent = entity.func_70099_a(d, 1.0f);
                    if (ent != null) {
                        ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
            }
            return true;
        }
        return false;
    }
}

