/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability;

import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class LuckModifier
extends IncrementalModifier {
    private static final Random LOOTING_RANDOM = new Random();

    public LuckModifier() {
        super(3432131);
        MinecraftForge.EVENT_BUS.addListener(this::onLooting);
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        TranslationTextComponent name = level > 3 ? new TranslationTextComponent(this.getTranslationKey() + ".beyond") : new TranslationTextComponent(this.getTranslationKey() + "." + level);
        return name.func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)this.getColor())));
    }

    @Override
    public ITextComponent getDisplayName(IModifierToolStack tool, int level) {
        int neededPerLevel = ModifierRecipeLookup.getNeededPerLevel(this);
        ITextComponent name = this.getDisplayName(level);
        if (neededPerLevel > 0) {
            int amount = this.getAmount(tool);
            int dispLevel = 3 + (amount - neededPerLevel) * 3 / neededPerLevel;
            if (level > 4) {
                dispLevel += (level - 4) * 3;
            }
            IFormattableTextComponent formattable = name.func_230532_e_();
            formattable = formattable.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + dispLevel));
            if (amount < neededPerLevel) {
                return formattable.func_240702_b_(": " + amount + " / " + neededPerLevel);
            }
            return formattable;
        }
        return name;
    }

    private int getEffectiveLevel(IModifierToolStack tool, int level, Random random) {
        int applyLevel = level * 3;
        int neededPerSlot = ModifierRecipeLookup.getNeededPerLevel(this);
        if (neededPerSlot > 0) {
            int neededPerLevel = neededPerSlot / 3;
            int amount = this.getAmount(tool);
            if (amount < neededPerLevel) {
                applyLevel -= 2;
            } else if ((amount -= neededPerLevel) < neededPerLevel) {
                --applyLevel;
            } else {
                amount -= neededPerLevel;
            }
            if (amount < neededPerLevel && amount < random.nextInt(neededPerLevel)) {
                --applyLevel;
            }
        }
        return applyLevel;
    }

    @Override
    public void applyEnchantments(IModifierToolStack tool, int level, BiConsumer<Enchantment, Integer> consumer) {
        int applyLevel = this.getEffectiveLevel(tool, level, RANDOM);
        if (applyLevel > 0) {
            consumer.accept(Enchantments.field_185308_t, applyLevel);
        }
    }

    private void onLooting(LootingLevelEvent event) {
        int level;
        ToolStack tool;
        ItemStack held;
        DamageSource damageSource = event.getDamageSource();
        if (damageSource == null) {
            return;
        }
        Entity source = event.getDamageSource().func_76346_g();
        if (source instanceof LivingEntity && TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)(held = ((LivingEntity)source).func_184614_ca()).func_77973_b()) && !(tool = ToolStack.from(held)).isBroken() && (level = tool.getModifierLevel(this)) > 0) {
            LOOTING_RANDOM.setSeed(source.func_130014_f_().func_82737_E());
            event.setLootingLevel(this.getEffectiveLevel(tool, level, LOOTING_RANDOM));
        }
    }
}

