/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.TankModifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class BucketingModifier
extends TankModifier {
    public BucketingModifier() {
        super(0xD8D8D8, 1000);
    }

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        super.addVolatileData(toolDefinition, baseStats, persistentData, level, volatileData);
        int capacity = this.getCapacity(volatileData);
        int remainder = capacity % 1000;
        if (remainder != 0) {
            this.addCapacity(volatileData, 1000 - remainder);
        }
    }

    private static boolean cannotContainFluid(World world, BlockPos pos, BlockState state, Fluid fluid) {
        Block block = state.func_177230_c();
        return !state.func_227032_a_(fluid) && (!(block instanceof ILiquidContainer) || !((ILiquidContainer)block).func_204510_a((IBlockReader)world, pos, state, fluid));
    }

    @Override
    public ActionResultType onBlockUse(IModifierToolStack tool, int level, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null || !player.func_213453_ef()) {
            return ActionResultType.PASS;
        }
        FluidStack fluidStack = this.getFluid(tool);
        if (fluidStack.getAmount() < 1000) {
            return ActionResultType.PASS;
        }
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof FlowingFluid)) {
            return ActionResultType.PASS;
        }
        Direction face = context.func_196000_l();
        World world = context.func_195991_k();
        BlockPos target = context.func_195995_a();
        BlockPos offset = target.func_177972_a(face);
        if (!world.func_175660_a(player, target) || !player.func_175151_a(offset, face, context.func_195996_i())) {
            return ActionResultType.PASS;
        }
        BlockState existing = world.func_180495_p(target);
        if (BucketingModifier.cannotContainFluid(world, target, existing, fluidStack.getFluid()) && BucketingModifier.cannotContainFluid(world, target = offset, existing = world.func_180495_p(target), fluidStack.getFluid())) {
            return ActionResultType.PASS;
        }
        boolean placed = false;
        if (world.func_230315_m_().func_236040_e_() && fluid.func_207185_a((ITag)FluidTags.field_206959_a)) {
            world.func_184133_a(player, target, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)target.func_177958_n() + Math.random(), (double)target.func_177956_o() + Math.random(), (double)target.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
            }
            placed = true;
        } else if (existing.func_227032_a_(fluid)) {
            if (!world.field_72995_K && !existing.func_185904_a().func_76224_d()) {
                world.func_175655_b(target, true);
            }
            if (world.func_175656_a(target, fluid.func_207188_f().func_206883_i()) || existing.func_204520_s().func_206889_d()) {
                world.func_184133_a(null, target, fluid.getAttributes().getEmptySound(fluidStack), SoundCategory.BLOCKS, 1.0f, 1.0f);
                placed = true;
            }
        } else if (existing.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)existing.func_177230_c()).func_204509_a((IWorld)world, target, existing, ((FlowingFluid)fluid).func_207204_a(false));
            world.func_184133_a(null, target, fluid.getAttributes().getEmptySound(fluidStack), SoundCategory.BLOCKS, 1.0f, 1.0f);
            placed = true;
        }
        if (placed) {
            this.drain(tool, fluidStack, 1000);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType onToolUse(IModifierToolStack tool, int level, World world, PlayerEntity player, Hand hand) {
        Fluid pickedUpFluid;
        if (player.func_213453_ef()) {
            return ActionResultType.PASS;
        }
        FluidStack fluidStack = this.getFluid(tool);
        if (this.getCapacity(tool) - fluidStack.getAmount() < 1000) {
            return ActionResultType.PASS;
        }
        BlockRayTraceResult trace = ToolCore.blockRayTrace(world, player, RayTraceContext.FluidMode.SOURCE_ONLY);
        if (trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResultType.PASS;
        }
        Direction face = trace.func_216354_b();
        BlockPos target = trace.func_216350_a();
        BlockPos offset = target.func_177972_a(face);
        if (!world.func_175660_a(player, target) || !player.func_175151_a(offset, face, player.func_184586_b(hand))) {
            return ActionResultType.PASS;
        }
        FluidState fluidState = world.func_204610_c(target);
        Fluid currentFluid = fluidStack.getFluid();
        if (fluidState.func_206888_e() || !fluidStack.isEmpty() && !currentFluid.func_207187_a(fluidState.func_206886_c())) {
            return ActionResultType.PASS;
        }
        BlockState state = world.func_180495_p(target);
        if (state.func_177230_c() instanceof IBucketPickupHandler && (pickedUpFluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, target, state)) != Fluids.field_204541_a) {
            player.func_184185_a(pickedUpFluid.getAttributes().getFillSound(fluidStack), 1.0f, 1.0f);
            if (!world.field_72995_K) {
                if (fluidStack.isEmpty()) {
                    this.setFluid(tool, new FluidStack(pickedUpFluid, 1000));
                } else if (pickedUpFluid == currentFluid) {
                    fluidStack.grow(1000);
                    this.setFluid(tool, fluidStack);
                } else {
                    TConstruct.log.error("Picked up a fluid {} that does not match the current fluid state {}, this should not happen", (Object)pickedUpFluid, (Object)fluidState.func_206886_c());
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

