/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item.small;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.VeiningAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class MattockTool
extends ToolCore {
    private static final Set<Material> EXTRA_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151577_b, Material.field_151575_d, Material.field_237214_y_, Material.field_215713_z, Material.field_151572_C});
    public static final VeiningAOEHarvestLogic HARVEST_LOGIC = new VeiningAOEHarvestLogic(0){

        @Override
        public boolean isEffectiveAgainst(IModifierToolStack tool, ItemStack stack, BlockState state) {
            return EXTRA_MATERIALS.contains(state.func_185904_a()) || super.isEffectiveAgainst(tool, stack, state);
        }

        @Override
        public float getDestroySpeed(ItemStack stack, BlockState blockState) {
            if (!stack.func_77942_o()) {
                return 1.0f;
            }
            ToolStack tool = ToolStack.from(stack);
            if (tool.isBroken()) {
                return 0.3f;
            }
            if (!this.isEffective(tool, stack, blockState)) {
                return 1.0f;
            }
            float speed = tool.getStats().getMiningSpeed();
            if (!blockState.isToolEffective(ToolType.SHOVEL)) {
                speed *= 0.75f;
            }
            return speed;
        }
    };

    public MattockTool(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    @Override
    public ToolHarvestLogic getToolHarvestLogic() {
        return HARVEST_LOGIC;
    }
}

