/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item.small;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.CircleAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.item.small.HarvestTool;

public class KamaTool
extends HarvestTool {
    public static final ToolHarvestLogic HARVEST_LOGIC = new HarvestLogic(1, true);

    public KamaTool(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    @Override
    public ToolHarvestLogic getToolHarvestLogic() {
        return HARVEST_LOGIC;
    }

    public static class HarvestLogic
    extends CircleAOEHarvestLogic {
        private static final Set<Material> EFFECTIVE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151584_j, Material.field_151569_G, Material.field_151580_n, Material.field_151585_k, Material.field_151582_l, Material.field_242934_h, Material.field_203243_f});

        public HarvestLogic(int diameter, boolean is3D) {
            super(diameter, is3D);
        }

        @Override
        public float getDestroySpeed(ItemStack stack, BlockState blockState) {
            float speed = super.getDestroySpeed(stack, blockState);
            if (blockState.func_185904_a() == Material.field_151580_n) {
                speed /= 3.0f;
            }
            return speed;
        }

        @Override
        public boolean isEffectiveAgainst(IModifierToolStack tool, ItemStack stack, BlockState state) {
            return state.func_177230_c() == Blocks.field_150473_bD || EFFECTIVE_MATERIALS.contains(state.func_185904_a()) || super.isEffectiveAgainst(tool, stack, state);
        }

        @Override
        public int getDamage(ToolStack tool, ItemStack stack, World world, BlockPos pos, BlockState state) {
            return state.func_235714_a_((ITag)BlockTags.field_232872_am_) ? 0 : 1;
        }

        @Override
        protected boolean removeBlock(PlayerEntity player, World world, BlockPos pos, boolean canHarvest) {
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof TripWireBlock) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208178_e, (Comparable)Boolean.TRUE), 4);
            }
            return super.removeBlock(player, world, pos, canHarvest);
        }
    }
}

