/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item.small;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.CircleAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.small.HarvestTool;

public class HandAxeTool
extends HarvestTool {
    private static final Set<Material> EXTRA_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C, Material.field_151584_j});
    public static final CircleAOEHarvestLogic HARVEST_LOGIC = new CircleAOEHarvestLogic(1, false){

        @Override
        public boolean isEffectiveAgainst(IModifierToolStack tool, ItemStack stack, BlockState state) {
            return EXTRA_MATERIALS.contains(state.func_185904_a()) || super.isEffectiveAgainst(tool, stack, state);
        }
    };

    public HandAxeTool(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    @Override
    public ToolHarvestLogic getToolHarvestLogic() {
        return HARVEST_LOGIC;
    }

    @Override
    public boolean dealDamage(ToolStack tool, LivingEntity player, Entity entity, float damage, boolean isCriticalHit, boolean fullyCharged) {
        boolean hit = super.dealDamage(tool, player, entity, damage, isCriticalHit, fullyCharged);
        if (hit && fullyCharged) {
            ToolAttackUtil.spawnAttachParticle((IParticleData)TinkerTools.axeAttackParticle.get(), (Entity)player, 0.8);
        }
        return hit;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

