/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item.broad;

import java.util.Collections;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.RectangleAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.small.KamaTool;

public class ScytheTool
extends KamaTool {
    public static final ToolHarvestLogic HARVEST_LOGIC = new KamaTool.HarvestLogic(3, true){

        @Override
        public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, ToolHarvestLogic.AOEMatchType matchType) {
            if (!this.canAOE(tool, stack, state, matchType)) {
                return Collections.emptyList();
            }
            int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
            int sides = (expanded + 1) / 2;
            return RectangleAOEHarvestLogic.calculate(this, tool, stack, world, player, origin, sideHit, 1 + sides, 1 + sides, 3 + expanded / 2 * 2, matchType);
        }
    };

    public ScytheTool(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    @Override
    public ToolHarvestLogic getToolHarvestLogic() {
        return HARVEST_LOGIC;
    }

    @Override
    public boolean dealDamage(ToolStack tool, LivingEntity living, Entity targetEntity, float damage, boolean isCritical, boolean fullyCharged) {
        boolean hit = super.dealDamage(tool, living, targetEntity, damage, isCritical, fullyCharged);
        if (fullyCharged) {
            double range = 3 + tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
            for (LivingEntity sideEntity : living.func_130014_f_().func_217357_a(LivingEntity.class, targetEntity.func_174813_aQ().func_72314_b(range, 0.25, range))) {
                if (sideEntity == living || sideEntity == targetEntity || living.func_184191_r((Entity)sideEntity) || sideEntity instanceof ArmorStandEntity && ((ArmorStandEntity)sideEntity).func_181026_s() || !(living.func_70068_e((Entity)sideEntity) < 8.0 + range)) continue;
                sideEntity.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(living.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(living.field_70177_z * ((float)Math.PI / 180)))));
                hit |= ToolAttackUtil.extraEntityAttack(this, tool, living, (Entity)sideEntity);
            }
            living.field_70170_p.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), SoundEvents.field_187730_dW, living.func_184176_by(), 1.0f, 1.0f);
            if (living instanceof PlayerEntity) {
                ((PlayerEntity)living).func_184810_cG();
            }
        }
        return hit;
    }
}

