/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipeBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipeBuilder;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.MaterialIds;
import slimeknights.tconstruct.world.TinkerWorld;

public class ToolsRecipeProvider
extends BaseRecipeProvider {
    public ToolsRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public String func_200397_b() {
        return "Tinkers' Construct Tool Recipes";
    }

    @Override
    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.addMaterialsRecipes(consumer);
        this.addPartRecipes(consumer);
        this.addTinkerStationRecipes(consumer);
    }

    private void addPartRecipes(Consumer<IFinishedRecipe> consumer) {
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.repairKit, 2, TinkerSmeltery.repairKitCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.pickaxeHead, 2, TinkerSmeltery.pickaxeHeadCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.hammerHead, 8, TinkerSmeltery.hammerHeadCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.smallAxeHead, 2, TinkerSmeltery.smallAxeHeadCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.broadAxeHead, 8, TinkerSmeltery.broadAxeHeadCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.swordBlade, 2, TinkerSmeltery.swordBladeCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.broadBlade, 8, TinkerSmeltery.broadBladeCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.toolBinding, 1, TinkerSmeltery.toolBindingCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.largePlate, 4, TinkerSmeltery.largePlateCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.toolHandle, 1, TinkerSmeltery.toolHandleCast);
        this.addPartRecipe(consumer, (Supplier<? extends IMaterialItem>)TinkerToolParts.toughHandle, 3, TinkerSmeltery.toughHandleCast);
    }

    private void addMaterialsRecipes(Consumer<IFinishedRecipe> consumer) {
        this.registerMaterial(consumer, MaterialIds.wood, Ingredient.func_199805_a((ITag)Tags.Items.RODS_WOODEN), 1, 2, "wood/sticks");
        this.registerMaterial(consumer, MaterialIds.wood, Ingredient.func_199805_a((ITag)ItemTags.field_199905_b), 1, 1, "wood/planks");
        this.registerMaterial(consumer, MaterialIds.wood, Ingredient.func_199805_a((ITag)ItemTags.field_200038_h), 4, 1, "wood/logs");
        this.registerMaterial(consumer, MaterialIds.stone, (Ingredient)new BaseRecipeProvider.CompoundIngredient(Ingredient.func_199805_a((ITag)Tags.Items.STONE), Ingredient.func_199805_a((ITag)Tags.Items.COBBLESTONE), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_235410_nt_})), 1, 1, "stone");
        this.registerMaterial(consumer, MaterialIds.flint, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151145_ak, Blocks.field_235337_cO_, Blocks.field_235338_cP_}), 1, 1, "flint");
        this.registerMaterial(consumer, MaterialIds.bone, Ingredient.func_199805_a((ITag)Tags.Items.BONES), 1, 1, "bone");
        this.registerMaterial(consumer, MaterialIds.necroticBone, Ingredient.func_199805_a(TinkerTags.Items.WITHER_BONES), 1, 1, "necrotic_bone");
        this.registerMetalMaterial(consumer, MaterialIds.iron, "iron", false);
        this.registerMaterial(consumer, MaterialIds.searedStone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedBrick}), 1, 1, "seared_stone/brick");
        this.registerMaterial(consumer, MaterialIds.searedStone, Ingredient.func_199805_a(TinkerTags.Items.SEARED_BLOCKS), 4, 1, "seared_stone/block");
        this.registerMetalMaterial(consumer, MaterialIds.copper, "copper", false);
        this.registerMaterial(consumer, MaterialIds.slimewood, Ingredient.func_199805_a(TinkerTags.Items.EARTH_SLIMEBALL), 1, 1, "slimewood/ball");
        this.registerMaterial(consumer, MaterialIds.slimewood, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH)}), 4, 1, "slimewood/congealed");
        this.registerMaterial(consumer, MaterialIds.slimewood, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerWorld.slime.get((Enum)SlimeType.EARTH)}), 5, 1, "slimewood/block");
        this.registerMetalMaterial(consumer, MaterialIds.roseGold, "rose_gold", false);
        this.registerMetalMaterial(consumer, MaterialIds.slimesteel, "slimesteel", false);
        this.registerMaterial(consumer, MaterialIds.nahuatl, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221655_bP}), 1, 1, "nahuatl");
        this.registerMetalMaterial(consumer, MaterialIds.tinkersBronze, "silicon_bronze", false);
        this.registerMetalMaterial(consumer, MaterialIds.pigIron, "pig_iron", false);
        this.registerMaterial(consumer, MaterialIds.pigIron, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerCommons.bacon}), 1, 4, "pig_iron/bacon");
        this.registerMetalMaterial(consumer, MaterialIds.cobalt, "cobalt", false);
        this.registerMetalMaterial(consumer, MaterialIds.queensSlime, "queens_slime", false);
        this.registerMetalMaterial(consumer, MaterialIds.manyullyn, "manyullyn", false);
        this.registerMetalMaterial(consumer, MaterialIds.hepatizon, "hepatizon", false);
        this.registerMetalMaterial(consumer, MaterialIds.silver, "silver", true);
        this.registerMetalMaterial(consumer, MaterialIds.lead, "lead", true);
        this.registerMetalMaterial(consumer, MaterialIds.electrum, "electrum", true);
        this.registerMetalMaterial(consumer, MaterialIds.bronze, "bronze", true);
        this.registerMetalMaterial(consumer, MaterialIds.steel, "steel", true);
        this.registerMetalMaterial(consumer, MaterialIds.constantan, "constantan", true);
    }

    private void addTinkerStationRecipes(Consumer<IFinishedRecipe> consumer) {
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.pickaxe);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.sledgeHammer);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.veinHammer);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.mattock);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.excavator);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.handAxe);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.broadAxe);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.kama);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.scythe);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.broadSword);
        this.registerBuildingRecipe(consumer, (Supplier<? extends ToolCore>)TinkerTools.cleaver);
    }

    private void registerBuildingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends ToolCore> sup) {
        ToolCore toolCore = sup.get();
        String name = Objects.requireNonNull(toolCore.getRegistryName()).func_110623_a();
        ToolBuildingRecipeBuilder.toolBuildingRecipe(toolCore).build(consumer, ToolsRecipeProvider.location("tools/building/" + name));
    }

    private void addPartRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends IMaterialItem> sup, int cost, CastItemObject cast) {
        String folder = "tools/parts/";
        IMaterialItem part = sup.get();
        String name = Objects.requireNonNull(part.func_199767_j().getRegistryName()).func_110623_a();
        PartRecipeBuilder.partRecipe(part).setPattern(ToolsRecipeProvider.location(name)).setCost(cost).build(consumer, ToolsRecipeProvider.location(folder + "builder/" + name));
        String castingFolder = folder + "casting/";
        MaterialCastingRecipeBuilder.tableRecipe(part).setItemCost(cost).setCast((ITag<Item>)cast.getMultiUseTag(), false).build(consumer, ToolsRecipeProvider.location(castingFolder + name + "_gold_cast"));
        MaterialCastingRecipeBuilder.tableRecipe(part).setItemCost(cost).setCast((ITag<Item>)cast.getSingleUseTag(), true).build(consumer, ToolsRecipeProvider.location(castingFolder + name + "_sand_cast"));
        MaterialIngredient ingredient = MaterialIngredient.fromItem(part);
        String partName = Objects.requireNonNull(part.func_199767_j().getRegistryName()).func_110623_a();
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)cast).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenGold.get(), 144)).setCast(ingredient, true).setSwitchSlots().build(consumer, ToolsRecipeProvider.location("smeltery/casting/casts/" + partName));
        MoldingRecipeBuilder.moldingTable((IItemProvider)cast.getSand()).setMaterial((IItemProvider)TinkerSmeltery.blankCast.getSand()).setPattern(ingredient, false).build(consumer, ToolsRecipeProvider.location("smeltery/casting/sand_casts/" + partName));
        MoldingRecipeBuilder.moldingTable((IItemProvider)cast.getRedSand()).setMaterial((IItemProvider)TinkerSmeltery.blankCast.getRedSand()).setPattern(ingredient, false).build(consumer, ToolsRecipeProvider.location("smeltery/casting/red_sand_casts/" + partName));
        MaterialMeltingRecipeBuilder.melting(part, cost).build(consumer, ToolsRecipeProvider.location(folder + "melting/" + part));
    }

    private void registerMaterial(Consumer<IFinishedRecipe> consumer, MaterialId material, Ingredient input, int value, int needed, String saveName) {
        MaterialRecipeBuilder.materialRecipe(material).setIngredient(input).setValue(value).setNeeded(needed).build(consumer, ToolsRecipeProvider.location("tools/materials/" + saveName));
    }

    private void registerMetalMaterial(Consumer<IFinishedRecipe> consumer, MaterialId material, String name, boolean optional) {
        Consumer<IFinishedRecipe> wrapped = optional ? ToolsRecipeProvider.withCondition(consumer, ToolsRecipeProvider.tagCondition("ingots/" + name)) : consumer;
        String matName = material.func_110623_a();
        this.registerMaterial(wrapped, material, Ingredient.func_199805_a(ToolsRecipeProvider.getTag("forge", "ingots/" + name)), 1, 1, matName + "/ingot");
        wrapped = optional ? ToolsRecipeProvider.withCondition(consumer, ToolsRecipeProvider.tagCondition("nuggets/" + name)) : consumer;
        this.registerMaterial(wrapped, material, Ingredient.func_199805_a(ToolsRecipeProvider.getTag("forge", "nuggets/" + name)), 1, 9, matName + "/nugget");
        wrapped = optional ? ToolsRecipeProvider.withCondition(consumer, ToolsRecipeProvider.tagCondition("storage_blocks/" + name)) : consumer;
        this.registerMaterial(wrapped, material, Ingredient.func_199805_a(ToolsRecipeProvider.getTag("forge", "storage_blocks/" + name)), 9, 1, matName + "/block");
    }
}

