/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.DataMaterial;
import slimeknights.tconstruct.tools.data.MaterialIds;

final class Materials {
    private static final int ORDER_GENERAL = 0;
    private static final int ORDER_HARVEST = 1;
    private static final int ORDER_WEAPON = 2;
    private static final int ORDER_SPECIAL = 3;
    private static final int ORDER_COMPAT = 5;
    private static final int ORDER_NETHER = 7;
    private static final int ORDER_END = 10;
    static final List<Pair<IMaterial, ICondition>> allMaterials = new ArrayList<Pair<IMaterial, ICondition>>();
    public static final IMaterial wood = Materials.mat(MaterialIds.wood, 1, 0, true, 9332251, TinkerModifiers.cultivated);
    public static final IMaterial stone = Materials.mat(MaterialIds.stone, 1, 1, true, 0x999999, TinkerModifiers.stonebound);
    public static final IMaterial flint = Materials.mat(MaterialIds.flint, 1, 2, true, 0x696969, TinkerModifiers.jagged);
    public static final IMaterial bone = Materials.mat(MaterialIds.bone, 1, 3, true, 15591103, TinkerModifiers.fractured);
    public static final IMaterial necroticBone = Materials.mat(MaterialIds.necroticBone, 1, 3, true, 0x4D4D4D, TinkerModifiers.necrotic);
    public static final IMaterial iron = Materials.mat(MaterialIds.iron, 2, 0, TinkerFluids.moltenIron, false, 0xCACACA, TinkerModifiers.sturdy);
    public static final IMaterial copper = Materials.mat(MaterialIds.copper, 2, 1, TinkerFluids.moltenCopper, true, 16490853, TinkerModifiers.dwarven);
    public static final IMaterial searedStone = Materials.mat(MaterialIds.searedStone, 2, 2, TinkerFluids.searedStone, false, 0x3F3F3F, TinkerModifiers.searing);
    public static final IMaterial slimewood = Materials.mat(new DataMaterial(MaterialIds.slimewood, 2, 3, false, 8570995, Materials.getOverslimeTrait(TinkerModifiers.overgrowth)));
    public static final IMaterial slimesteel = Materials.overslimeMat(MaterialIds.slimesteel, 3, 0, TinkerFluids.moltenSlimesteel, false, 7653575, TinkerModifiers.overcast);
    public static final IMaterial tinkersBronze = Materials.mat(MaterialIds.tinkersBronze, 3, 1, TinkerFluids.moltenTinkersBronze, false, 16371570, TinkerModifiers.wellMaintained);
    public static final IMaterial nahuatl = Materials.mat(MaterialIds.nahuatl, 3, 2, false, 6298820, TinkerModifiers.lacerating);
    public static final IMaterial roseGold = Materials.mat(MaterialIds.roseGold, 3, 3, TinkerFluids.moltenRoseGold, false, 16240059, TinkerModifiers.enhanced);
    public static final IMaterial pigIron = Materials.mat(MaterialIds.pigIron, 3, 3, TinkerFluids.moltenPigIron, false, 15771812, TinkerModifiers.tasty);
    public static final IMaterial cobalt = Materials.mat(MaterialIds.cobalt, 3, 7, TinkerFluids.moltenCobalt, false, 2324189, TinkerModifiers.lightweight);
    public static final IMaterial queensSlime = Materials.overslimeMat(MaterialIds.queensSlime, 4, 0, TinkerFluids.moltenQueensSlime, false, 2321477, TinkerModifiers.overlord);
    public static final IMaterial hepatizon = Materials.mat(MaterialIds.hepatizon, 4, 1, TinkerFluids.moltenHepatizon, false, 6310251, TinkerModifiers.momentum);
    public static final IMaterial manyullyn = Materials.mat(MaterialIds.manyullyn, 4, 2, TinkerFluids.moltenManyullyn, false, 9593292, TinkerModifiers.insatiable);
    public static final IMaterial lead = Materials.compatMat(MaterialIds.lead, 2, 5, TinkerFluids.moltenLead, TinkerModifiers.heavy);
    public static final IMaterial silver = Materials.compatMat(MaterialIds.silver, 2, 5, TinkerFluids.moltenSilver, TinkerModifiers.smite);
    public static final IMaterial electrum = Materials.compatMat(MaterialIds.electrum, 3, 5, TinkerFluids.moltenElectrum, TinkerModifiers.experienced);
    public static final IMaterial bronze = Materials.compatMat(MaterialIds.bronze, 3, 1, TinkerFluids.moltenBronze, TinkerModifiers.wellMaintained2);
    public static final IMaterial steel = Materials.compatMat(MaterialIds.steel, 3, 0, TinkerFluids.moltenSteel, TinkerModifiers.ductile);
    public static final IMaterial constantan = Materials.compatMat(MaterialIds.constantan, 3, 5, TinkerFluids.moltenConstantan, TinkerModifiers.temperate);

    private static Supplier<List<ModifierEntry>> traitSupplier(@Nullable Supplier<? extends Modifier> trait) {
        if (trait == null) {
            return Collections::emptyList;
        }
        return () -> Collections.singletonList(new ModifierEntry((Modifier)trait.get(), 1));
    }

    private static IMaterial mat(IMaterial material, @Nullable ICondition condition) {
        allMaterials.add((Pair<IMaterial, ICondition>)Pair.of((Object)material, (Object)condition));
        return material;
    }

    private static IMaterial mat(IMaterial material) {
        return Materials.mat(material, null);
    }

    private static IMaterial mat(MaterialId location, int tier, int order, Supplier<? extends Fluid> fluid, boolean craftable, int color, @Nullable Supplier<? extends Modifier> trait) {
        return Materials.mat(new DataMaterial(location, tier, order, fluid, 144, craftable, color, Materials.traitSupplier(trait)));
    }

    private static IMaterial overslimeMat(MaterialId location, int tier, int order, Supplier<? extends Fluid> fluid, boolean craftable, int color, Supplier<? extends Modifier> trait) {
        return Materials.mat(new DataMaterial(location, tier, order, fluid, 144, craftable, color, Materials.getOverslimeTrait(trait)));
    }

    private static IMaterial mat(MaterialId location, int tier, int order, boolean craftable, int color, @Nullable Supplier<? extends Modifier> trait) {
        return Materials.mat(new DataMaterial(location, tier, order, craftable, color, Materials.traitSupplier(trait)));
    }

    private static IMaterial compatMat(MaterialId location, int tier, int order, Supplier<? extends Fluid> fluid, @Nullable Supplier<? extends Modifier> trait) {
        NotCondition condition = new NotCondition((ICondition)new TagEmptyCondition("forge", "ingots/" + location.func_110623_a()));
        return Materials.mat(new DataMaterial(location, tier, order, fluid, 144, false, fluid.get().getAttributes().getColor() & 0xFFFFFF, Materials.traitSupplier(trait)), (ICondition)condition);
    }

    private static Supplier<List<ModifierEntry>> getOverslimeTrait(Supplier<? extends Modifier> trait) {
        return () -> Arrays.asList(new ModifierEntry((Modifier)trait.get(), 1), new ModifierEntry((Modifier)TinkerModifiers.overslime.get(), 1));
    }

    private Materials() {
    }
}

