/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.data.GenericDataProvider;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialStatJsonWrapper;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsManager;
import slimeknights.tconstruct.tools.data.MaterialStats;

public class MaterialStatsDataProvider
extends GenericDataProvider {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonStatWrapper.class, (Object)new StatSerializer(MaterialStatsManager.GSON)).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();

    public MaterialStatsDataProvider(DataGenerator gen) {
        super(gen, "materials/stats", GSON);
    }

    public void func_200398_a(DirectoryCache cache) {
        MaterialStats.allMaterialStats.forEach((materialId, iMaterialStats) -> this.saveThing(cache, (ResourceLocation)materialId, this.convert((MaterialId)((Object)materialId), (List<IMaterialStats>)iMaterialStats)));
    }

    private JsonWrapper convert(MaterialId material, List<IMaterialStats> stats) {
        List<JsonStatWrapper> wrappedStats = stats.stream().map(stat -> new JsonStatWrapper(stat.getIdentifier(), (IMaterialStats)stat)).collect(Collectors.toList());
        return new JsonWrapper(material, wrappedStats);
    }

    public String func_200397_b() {
        return "TConstruct Material Stats";
    }

    private static class StatSerializer
    implements JsonSerializer<JsonStatWrapper> {
        private final Gson gson;

        public JsonElement serialize(JsonStatWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonElement original = this.gson.toJsonTree((Object)src);
            JsonObject output = new JsonObject();
            original.getAsJsonObject().entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonPrimitive()).forEach(entry -> output.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            original.getAsJsonObject().get("stat").getAsJsonObject().entrySet().forEach(entry -> output.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            return output;
        }

        public StatSerializer(Gson gson) {
            this.gson = gson;
        }
    }

    private static class JsonStatWrapper
    extends MaterialStatJsonWrapper.BaseMaterialStatsJson {
        private final IMaterialStats stat;

        public JsonStatWrapper(MaterialStatsId id, IMaterialStats stat) {
            super(id);
            this.stat = stat;
        }

        public IMaterialStats getStat() {
            return this.stat;
        }
    }

    private static class JsonWrapper {
        private final ResourceLocation materialId;
        private final List<JsonStatWrapper> stats;

        public JsonWrapper(ResourceLocation materialId, List<JsonStatWrapper> stats) {
            this.materialId = materialId;
            this.stats = stats;
        }
    }
}

