/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.tools.data.MaterialIds;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

final class MaterialStats {
    static final Map<MaterialId, List<IMaterialStats>> allMaterialStats = new HashMap<MaterialId, List<IMaterialStats>>();

    private static void addMaterialStats(MaterialId location, IMaterialStats ... stats) {
        allMaterialStats.computeIfAbsent(location, materialId -> new ArrayList()).addAll(Arrays.asList(stats));
    }

    private MaterialStats() {
    }

    static {
        MaterialStats.addMaterialStats(MaterialIds.wood, new HeadMaterialStats(60, 2.0f, 0, 0.0f), HandleMaterialStats.DEFAULT, ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.flint, new HeadMaterialStats(85, 3.5f, 1, 1.25f), HandleMaterialStats.DEFAULT.withDurability(0.8f).withAttackDamage(1.1f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.stone, new HeadMaterialStats(130, 4.0f, 1, 1.0f), HandleMaterialStats.DEFAULT.withDurability(0.8f).withMiningSpeed(1.1f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.bone, new HeadMaterialStats(100, 2.5f, 1, 1.25f), HandleMaterialStats.DEFAULT.withDurability(0.75f).withAttackSpeed(1.1f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.necroticBone, new HeadMaterialStats(125, 2.0f, 1, 1.5f), HandleMaterialStats.DEFAULT.withDurability(0.65f).withAttackSpeed(1.15f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.iron, new HeadMaterialStats(250, 6.0f, 2, 2.0f), HandleMaterialStats.DEFAULT.withDurability(1.15f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.searedStone, new HeadMaterialStats(150, 5.0f, 2, 2.25f), HandleMaterialStats.DEFAULT.withDurability(0.8f).withAttackDamage(1.2f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.copper, new HeadMaterialStats(210, 6.5f, 2, 1.5f), HandleMaterialStats.DEFAULT.withDurability(0.8f).withMiningSpeed(1.2f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.slimewood, new HeadMaterialStats(375, 4.0f, 2, 1.0f), HandleMaterialStats.DEFAULT.withDurability(1.3f).withMiningSpeed(0.85f).withAttackDamage(0.85f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.roseGold, new HeadMaterialStats(175, 12.0f, 2, 1.0f), HandleMaterialStats.DEFAULT.withDurability(0.6f).withAttackSpeed(1.25f).withMiningSpeed(1.3f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.silver, new HeadMaterialStats(300, 5.5f, 2, 2.25f), HandleMaterialStats.DEFAULT.withDurability(0.9f).withAttackSpeed(1.1f).withAttackDamage(1.1f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.lead, new HeadMaterialStats(200, 5.0f, 2, 2.5f), HandleMaterialStats.DEFAULT.withAttackSpeed(0.7f).withAttackDamage(1.25f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.electrum, new HeadMaterialStats(225, 11.0f, 2, 1.5f), HandleMaterialStats.DEFAULT.withDurability(0.8f).withAttackSpeed(1.15f).withMiningSpeed(1.2f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.slimesteel, new HeadMaterialStats(1040, 6.5f, 3, 2.5f), HandleMaterialStats.DEFAULT.withDurability(1.25f).withAttackSpeed(0.95f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.nahuatl, new HeadMaterialStats(350, 4.5f, 3, 3.0f), HandleMaterialStats.DEFAULT.withDurability(0.9f).withAttackSpeed(0.9f).withAttackDamage(1.5f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.tinkersBronze, new HeadMaterialStats(720, 7.0f, 3, 2.0f), HandleMaterialStats.DEFAULT.withDurability(1.1f).withMiningSpeed(1.15f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.pigIron, new HeadMaterialStats(580, 6.0f, 3, 2.5f), HandleMaterialStats.DEFAULT.withDurability(1.15f).withAttackDamage(1.1f).withMiningSpeed(0.8f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.steel, new HeadMaterialStats(775, 7.0f, 3, 2.5f), HandleMaterialStats.DEFAULT.withDurability(1.15f).withAttackSpeed(1.1f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.bronze, new HeadMaterialStats(760, 7.0f, 3, 2.0f), HandleMaterialStats.DEFAULT.withDurability(1.15f).withMiningSpeed(1.1f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.constantan, new HeadMaterialStats(675, 6.5f, 3, 2.5f), HandleMaterialStats.DEFAULT.withDurability(0.9f).withMiningSpeed(1.3f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.cobalt, new HeadMaterialStats(800, 8.0f, 3, 2.5f), HandleMaterialStats.DEFAULT.withDurability(1.1f).withAttackSpeed(1.1f).withMiningSpeed(1.1f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.queensSlime, new HeadMaterialStats(1750, 7.0f, 4, 2.0f), HandleMaterialStats.DEFAULT.withDurability(1.4f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.manyullyn, new HeadMaterialStats(1500, 8.0f, 4, 4.0f), HandleMaterialStats.DEFAULT.withDurability(1.2f).withAttackDamage(1.4f), ExtraMaterialStats.DEFAULT);
        MaterialStats.addMaterialStats(MaterialIds.hepatizon, new HeadMaterialStats(1450, 10.0f, 4, 3.0f), HandleMaterialStats.DEFAULT.withDurability(1.1f).withAttackSpeed(0.9f).withMiningSpeed(1.4f), ExtraMaterialStats.DEFAULT);
    }
}

