/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.text.Color;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public class DataMaterial
implements IMaterial {
    private final MaterialId identifier;
    private final int tier;
    private final int sortOrder;
    private final Supplier<? extends Fluid> fluid;
    private final int fluidPerUnit;
    private final boolean craftable;
    private final Color color;
    private final Supplier<List<ModifierEntry>> traits;

    public DataMaterial(MaterialId identifier, int tier, int sortOrder, Supplier<? extends Fluid> fluid, int fluidPerUnit, boolean craftable, int color, Supplier<List<ModifierEntry>> traits) {
        this.identifier = identifier;
        this.tier = tier;
        this.sortOrder = sortOrder;
        this.fluid = fluid;
        this.fluidPerUnit = fluidPerUnit;
        this.craftable = craftable;
        this.color = Color.func_240743_a_((int)color);
        this.traits = traits;
    }

    public DataMaterial(MaterialId identifier, int tier, int sortOrder, boolean craftable, int color, Supplier<List<ModifierEntry>> traits) {
        this(identifier, tier, sortOrder, (Supplier<? extends Fluid>)Fluids.field_204541_a.delegate, 0, craftable, color, traits);
    }

    @Override
    public Fluid getFluid() {
        return this.fluid.get();
    }

    @Override
    public int getTemperature() {
        Fluid fluid = this.fluid.get();
        if (fluid == Fluids.field_204541_a) {
            return 0;
        }
        return fluid.getAttributes().getTemperature() - 300;
    }

    @Override
    public List<ModifierEntry> getTraits() {
        return this.traits.get();
    }

    @Override
    public MaterialId getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public int getFluidPerUnit() {
        return this.fluidPerUnit;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public Color getColor() {
        return this.color;
    }
}

