/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.exception.TinkerAPIMaterialException;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public final class ToolStatsBuilder {
    private final List<HeadMaterialStats> heads;
    private final List<HandleMaterialStats> handles;
    private final List<ExtraMaterialStats> extras;

    public static ToolStatsBuilder from(List<IMaterial> materials, ToolDefinition toolDefinition) {
        List<IToolPart> requiredComponents = toolDefinition.getRequiredComponents();
        if (materials.size() != requiredComponents.size()) {
            throw TinkerAPIMaterialException.statBuilderWithInvalidMaterialCount();
        }
        List<HeadMaterialStats> headStats = ToolStatsBuilder.listOfCompatibleWith(HeadMaterialStats.ID, materials, requiredComponents);
        int primaryWeight = toolDefinition.getBaseStatDefinition().getPrimaryHeadWeight();
        if (primaryWeight > 1 && headStats.size() > 1) {
            for (int i = 1; i < primaryWeight; ++i) {
                headStats.add(headStats.get(0));
            }
        }
        return new ToolStatsBuilder(headStats, ToolStatsBuilder.listOfCompatibleWith(HandleMaterialStats.ID, materials, requiredComponents), ToolStatsBuilder.listOfCompatibleWith(ExtraMaterialStats.ID, materials, requiredComponents));
    }

    private static <T extends IMaterialStats> List<T> listOfCompatibleWith(MaterialStatsId statsId, List<IMaterial> materials, List<IToolPart> requiredComponents) {
        return Streams.zip(materials.stream(), requiredComponents.stream(), (material, partMaterialType) -> ToolStatsBuilder.fetchStatsOrDefault(statsId, material, partMaterialType)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static <T extends IMaterialStats> T fetchStatsOrDefault(MaterialStatsId statsId, IMaterial material, IToolPart requiredComponent) {
        if (statsId.equals((Object)requiredComponent.getStatType())) {
            return (T)MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), statsId).orElseGet(() -> MaterialRegistry.getInstance().getDefaultStats(statsId));
        }
        return null;
    }

    public StatsNBT buildStats() {
        return StatsNBT.builder().durability(this.buildDurability()).harvestLevel(this.buildHarvestLevel()).attackDamage(this.buildAttack()).attackSpeed(this.buildAttackSpeed()).miningSpeed(this.buildMiningSpeed()).build();
    }

    public int buildDurability() {
        double averageHeadDurability = this.getAverageValue(this.heads, HeadMaterialStats::getDurability);
        double averageHandleModifier = this.getAverageValue(this.handles, HandleMaterialStats::getDurability, 1.0);
        return Math.max(1, (int)(averageHeadDurability * averageHandleModifier));
    }

    public float buildMiningSpeed() {
        double averageHeadSpeed = this.getAverageValue(this.heads, HeadMaterialStats::getMiningSpeed);
        double averageHandleModifier = this.getAverageValue(this.handles, HandleMaterialStats::getMiningSpeed, 1.0);
        return (float)Math.max(0.1, averageHeadSpeed * averageHandleModifier);
    }

    public float buildAttackSpeed() {
        double averageHandleModifier = this.getAverageValue(this.handles, HandleMaterialStats::getAttackSpeed, 1.0);
        return (float)averageHandleModifier;
    }

    public int buildHarvestLevel() {
        return this.heads.stream().mapToInt(HeadMaterialStats::getHarvestLevel).max().orElse(0);
    }

    public float buildAttack() {
        double averageHeadAttack = this.getAverageValue(this.heads, HeadMaterialStats::getAttack);
        double averageHandle = this.getAverageValue(this.handles, HandleMaterialStats::getAttackDamage, 1.0);
        return (float)Math.max(0.0, averageHeadAttack * averageHandle);
    }

    private <T extends IMaterialStats> double getAverageValue(List<T> stats, Function<T, ? extends Number> statGetter) {
        return this.getAverageValue(stats, statGetter, 0.0);
    }

    private <T extends IMaterialStats, N extends Number> double getAverageValue(List<T> stats, Function<T, N> statGetter, double missingValue) {
        return stats.stream().mapToDouble(value -> ((Number)statGetter.apply(value)).doubleValue()).average().orElse(missingValue);
    }

    public ToolStatsBuilder withHeads(List<HeadMaterialStats> heads) {
        return this.heads == heads ? this : new ToolStatsBuilder(heads, this.handles, this.extras);
    }

    public ToolStatsBuilder withHandles(List<HandleMaterialStats> handles) {
        return this.handles == handles ? this : new ToolStatsBuilder(this.heads, handles, this.extras);
    }

    public ToolStatsBuilder withExtras(List<ExtraMaterialStats> extras) {
        return this.extras == extras ? this : new ToolStatsBuilder(this.heads, this.handles, extras);
    }

    public ToolStatsBuilder(List<HeadMaterialStats> heads, List<HandleMaterialStats> handles, List<ExtraMaterialStats> extras) {
        this.heads = heads;
        this.handles = handles;
        this.extras = extras;
    }

    protected List<HeadMaterialStats> getHeads() {
        return this.heads;
    }

    protected List<HandleMaterialStats> getHandles() {
        return this.handles;
    }

    protected List<ExtraMaterialStats> getExtras() {
        return this.extras;
    }
}

