/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.List;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tools.helper.BlockSideHitListener;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolEvents {
    @SubscribeEvent
    static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        List<ModifierEntry> modifiers;
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (!TinkerTags.Items.HARVEST.func_230235_a_((Object)stack.func_77973_b())) {
            return;
        }
        ToolStack tool = ToolStack.from(stack);
        if (!tool.isBroken() && !(modifiers = tool.getModifierList()).isEmpty()) {
            PlayerEntity player = event.getPlayer();
            float miningSpeedModifier = Modifier.getMiningModifier((LivingEntity)player);
            boolean isEffective = stack.func_150998_b(event.getState());
            Direction direction = BlockSideHitListener.getSideHit(player);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().onBreakSpeed(tool, entry.getLevel(), event, direction, isEffective, miningSpeedModifier);
                if (!event.isCanceled()) continue;
                break;
            }
        }
    }

    @SubscribeEvent
    static void onHarvest(TinkerToolEvent.ToolHarvestEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        BlockState state = event.getState();
        Block block = state.func_177230_c();
        ServerWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        if (block == Blocks.field_150423_aK) {
            Direction facing = event.getContext().func_196000_l();
            if (facing.func_176740_k() == Direction.Axis.Y) {
                facing = event.getContext().func_195992_f().func_176734_d();
            }
            world.func_184133_a(null, pos, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(pos, (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)facing), 11);
            ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.func_177958_n() + 0.5 + (double)facing.func_82601_c() * 0.65, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5 + (double)facing.func_82599_e() * 0.65, new ItemStack((IItemProvider)Items.field_151080_bb, 4));
            itemEntity.func_213293_j(0.05 * (double)facing.func_82601_c() + world.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)facing.func_82599_e() + world.field_73012_v.nextDouble() * 0.02);
            world.func_217376_c((Entity)itemEntity);
            event.setResult(Event.Result.ALLOW);
        }
        if (block instanceof BeehiveBlock) {
            BeehiveBlock beehive = (BeehiveBlock)block;
            int level = (Integer)state.func_177229_b((Property)BeehiveBlock.field_226873_c_);
            if (level >= 5) {
                world.func_184133_a(null, pos, SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_226635_pU_, 3));
                if (!CampfireBlock.func_235474_a_((World)world, (BlockPos)pos)) {
                    if (beehive.func_226882_d_((World)world, pos)) {
                        beehive.func_226881_b_((World)world, pos);
                    }
                    beehive.func_226877_a_((World)world, state, pos, event.getPlayer(), BeehiveTileEntity.State.EMERGENCY);
                } else {
                    beehive.func_226876_a_((World)world, state, pos);
                }
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

