/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.model.tools.ToolModel;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.client.particles.AxeAttackParticle;
import slimeknights.tconstruct.tools.client.particles.HammerAttackParticle;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolClientEvents
extends ClientEventBase {
    private static final IItemColor materialColorHandler = (stack, index) -> Optional.of(IMaterialItem.getMaterialIdFromStack(stack)).filter(material -> !material.equals((Object)IMaterial.UNKNOWN_ID)).flatMap(MaterialRenderInfoLoader.INSTANCE::getRenderInfo).map(MaterialRenderInfo::getVertexColor).orElse(-1);
    private static final IItemColor toolColorHandler = (stack, index) -> {
        MaterialId material = MaterialIdNBT.from(stack).getMaterial(index);
        if (!IMaterial.UNKNOWN_ID.equals((Object)material)) {
            return MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material).map(MaterialRenderInfo::getVertexColor).orElse(-1);
        }
        return -1;
    };

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Util.getResource("material"), (IModelLoader)MaterialModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Util.getResource("tool"), (IModelLoader)ToolModel.LOADER);
    }

    @SubscribeEvent
    static void clientSetupEvent(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TinkerTools.indestructibleItem.get()), manager -> new ItemRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::onTooltipEvent);
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)TinkerTools.hammerAttackParticle.get(), HammerAttackParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)TinkerTools.axeAttackParticle.get(), AxeAttackParticle.Factory::new);
    }

    @SubscribeEvent
    static void itemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.pickaxe);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.sledgeHammer);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.veinHammer);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.mattock);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.excavator);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.handAxe);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.broadAxe);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.kama);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.scythe);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.broadSword);
        ToolClientEvents.registerToolItemColors(colors, TinkerTools.cleaver);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.repairKit);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.pickaxeHead);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.hammerHead);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.smallAxeHead);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.broadAxeHead);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.swordBlade);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.broadBlade);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.toolBinding);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.largePlate);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.toolHandle);
        ToolClientEvents.registerMaterialItemColors(colors, TinkerToolParts.toughHandle);
    }

    private static void onTooltipEvent(ItemTooltipEvent event) {
        if (event.getFlags().func_194127_a() && event.getItemStack().func_77973_b() instanceof ToolCore) {
            event.getToolTip().removeIf(text -> text instanceof TranslationTextComponent && ((TranslationTextComponent)text).func_150268_i().equals("item.durability"));
        }
    }

    public static void registerMaterialItemColors(ItemColors colors, Supplier<? extends MaterialItem> item) {
        colors.func_199877_a(materialColorHandler, new IItemProvider[]{item.get()});
    }

    public static void registerToolItemColors(ItemColors colors, Supplier<? extends ToolCore> item) {
        colors.func_199877_a(toolColorHandler, new IItemProvider[]{(IItemProvider)item.get()});
    }
}

