/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.function.IntConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerToolParts;

public class TinkerStationRepairRecipe
implements ITinkerStationRecipe {
    protected static final ValidatedResult FULLY_REPAIRED = ValidatedResult.failure(Util.makeTranslationKey("recipe", "tool_repair.fully_repaired"), new Object[0]);
    private static final IntConsumer NO_ACTION = i -> {};
    private final ResourceLocation id;

    public static boolean canRepairWith(ToolStack tool, IMaterial material) {
        for (int part : tool.getDefinition().getRepairParts()) {
            if (tool.getMaterial(part) != material) continue;
            return true;
        }
        return false;
    }

    protected IMaterial getMaterialFrom(ITinkerStationInventory inv, int slot) {
        ItemStack item = inv.getInput(slot);
        if (item.func_77973_b() == TinkerToolParts.repairKit.get()) {
            return IMaterialItem.getMaterialFromStack(item);
        }
        MaterialRecipe recipe = inv.getInputMaterial(slot);
        if (recipe != null) {
            return recipe.getMaterial();
        }
        return IMaterial.UNKNOWN;
    }

    protected float repairFactorPerItem(ITinkerStationInventory inv, int slot, IMaterial repairMaterial) {
        ItemStack stack = inv.getInput(slot);
        if (stack.func_77973_b() == TinkerToolParts.repairKit.get()) {
            return (float)(MaterialRecipe.getHeadDurability(repairMaterial.getIdentifier()) * 2) / 3.0f;
        }
        MaterialRecipe recipe = inv.getInputMaterial(slot);
        if (recipe != null) {
            return recipe.getRepairPerItem();
        }
        return 0.0f;
    }

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.func_190926_b() || !TinkerTags.Items.MULTIPART_TOOL.func_230235_a_((Object)tinkerable.func_77973_b())) {
            return false;
        }
        IMaterial material = null;
        ToolStack tool = ToolStack.from(tinkerable);
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b()) continue;
            IMaterial inputMaterial = this.getMaterialFrom(inv, i);
            if (inputMaterial == IMaterial.UNKNOWN) {
                return false;
            }
            if (!(material == null ? !TinkerStationRepairRecipe.canRepairWith(tool, material = inputMaterial) : material != inputMaterial)) continue;
            return false;
        }
        return material != null;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        int repairNeeded;
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        if (tool.getDefinition() == ToolDefinition.EMPTY) {
            return ValidatedResult.PASS;
        }
        if (!tool.isBroken() && tool.getDamage() == 0) {
            return FULLY_REPAIRED;
        }
        IMaterial primaryMaterial = tool.getMaterial(tool.getDefinition().getRepairParts()[0]);
        int repairRemaining = repairNeeded = tool.getDamage();
        for (int i = 0; i < inv.getInputCount() && repairRemaining > 0; repairRemaining -= this.repairFromSlot(tool, primaryMaterial, inv, repairRemaining, i, NO_ACTION), ++i) {
        }
        if (repairRemaining < repairNeeded) {
            tool = tool.copy();
            ToolDamageUtil.repair(tool, repairNeeded - repairRemaining);
            return ValidatedResult.success(tool.createStack());
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationInventory inv) {
        int slot;
        ToolStack inputTool = ToolStack.from(inv.getTinkerableStack());
        ToolStack resultTool = ToolStack.from(result);
        int repairRemaining = inputTool.getDamage() - resultTool.getDamage();
        IMaterial primaryMaterial = inputTool.getMaterial(inputTool.getDefinition().getRepairParts()[0]);
        for (int i = 0; i < inv.getInputCount() && repairRemaining > 0; repairRemaining -= this.repairFromSlot(inputTool, primaryMaterial, inv, repairRemaining, i, count -> inv.shrinkInput(slot, count)), ++i) {
            slot = i;
        }
        if (repairRemaining > 0) {
            TConstruct.log.error("Recipe repair on {} consumed too few items. {} durability unaccounted for", (Object)result, (Object)repairRemaining);
        }
    }

    private int repairFromSlot(ToolStack tool, IMaterial primaryMaterial, ITinkerStationInventory inv, int repairNeeded, int slot, IntConsumer amountConsumer) {
        ItemStack stack = inv.getInput(slot);
        if (!stack.func_190926_b()) {
            IMaterial repairMaterial = this.getMaterialFrom(inv, slot);
            float durabilityPerItem = this.repairFactorPerItem(inv, slot, repairMaterial);
            if (repairMaterial != IMaterial.UNKNOWN && durabilityPerItem > 0.0f) {
                if (repairMaterial != primaryMaterial) {
                    durabilityPerItem /= (float)tool.getDefinition().getBaseStatDefinition().getPrimaryHeadWeight();
                }
                for (ModifierEntry entry : tool.getModifierList()) {
                    durabilityPerItem = entry.getModifier().getRepairFactor(tool, entry.getLevel(), durabilityPerItem);
                    if (!(durabilityPerItem <= 0.0f)) continue;
                    return 0;
                }
                int applied = Math.min(stack.func_190916_E(), (int)Math.ceil((float)repairNeeded / durabilityPerItem));
                amountConsumer.accept(applied);
                return (int)((float)applied * durabilityPerItem);
            }
        }
        return 0;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.tinkerStationRepairSerializer.get();
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public TinkerStationRepairRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }
}

