/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.List;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialItemCostLookup;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class TinkerStationPartSwapping
implements ITinkerStationRecipe {
    private static final ValidatedResult TOO_MANY_PARTS = ValidatedResult.failure(Util.makeTranslationKey("recipe", "part_swapping.too_many_parts"), new Object[0]);
    protected final ResourceLocation id;

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.func_190926_b() || !(tinkerable.func_77973_b() instanceof ToolCore)) {
            return false;
        }
        List<IToolPart> parts = ((ToolCore)tinkerable.func_77973_b()).getToolDefinition().getRequiredComponents();
        boolean foundItem = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b()) continue;
            if (foundItem) {
                return false;
            }
            Item item = stack.func_77973_b();
            if (!(item instanceof IToolPart) || !parts.contains(item)) {
                return false;
            }
            foundItem = true;
        }
        return foundItem;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        List<IToolPart> parts = tool.getDefinition().getRequiredComponents();
        if (parts.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (!(item instanceof IToolPart)) {
                return ValidatedResult.PASS;
            }
            IToolPart part = (IToolPart)item;
            IMaterial partMaterial = ((IToolPart)item).getMaterial(stack);
            if (partMaterial == IMaterial.UNKNOWN) {
                return ValidatedResult.PASS;
            }
            int index = i;
            if ((i >= parts.size() || parts.get(i).func_199767_j() != item) && (index = parts.indexOf(item)) == -1) {
                return ValidatedResult.PASS;
            }
            IMaterial toolMaterial = tool.getMaterial(index);
            if (toolMaterial == partMaterial) {
                return ValidatedResult.PASS;
            }
            tool = tool.copy();
            tool.replaceMaterial(index, partMaterial);
            ValidatedResult toolValidation = tool.validate();
            if (toolValidation.hasError()) {
                return toolValidation;
            }
            if (part.getStatType().equals((Object)HeadMaterialStats.ID)) {
                ToolStack finalTool = tool;
                int cost = MaterialItemCostLookup.getTableCost(part);
                if (cost > 0) {
                    Optional<HeadMaterialStats> optional = MaterialRegistry.getInstance().getMaterialStats(partMaterial.getIdentifier(), HeadMaterialStats.ID);
                    optional.ifPresent(stats -> {
                        float factor = (float)cost / 3.0f;
                        for (ModifierEntry entry : finalTool.getModifierList()) {
                            factor = entry.getModifier().getRepairFactor(finalTool, entry.getLevel(), factor);
                            if (!(factor <= 0.0f)) continue;
                            return;
                        }
                        ToolDamageUtil.repair(finalTool, (int)((float)stats.getDurability() * factor));
                    });
                }
            }
            return ValidatedResult.success(tool.createStack());
        }
        return ValidatedResult.PASS;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.tinkerStationPartSwappingSerializer.get();
    }

    public TinkerStationPartSwapping(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }
}

