/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.inventory.table.partbuilder;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.world.World;
import slimeknights.mantle.inventory.IContainerCraftingCustom;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipe;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.client.inventory.table.ResultSlot;
import slimeknights.tconstruct.tables.inventory.BaseStationContainer;
import slimeknights.tconstruct.tables.inventory.table.partbuilder.PartBuilderInventoryWrapper;
import slimeknights.tconstruct.tables.tileentity.table.PartBuilderTileEntity;

public class PartBuilderContainer
extends BaseStationContainer<PartBuilderTileEntity>
implements IContainerCraftingCustom {
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private List<PartRecipe> partRecipes = Lists.newArrayList();
    private final Predicate<PartRecipe> partFilter;
    private final IInventory craftResult;
    private final PartBuilderInventoryWrapper craftInventory;
    private final Slot patternSlot;
    private final Slot inputSlot;
    private final Slot outputSlot;
    private final World world;

    public PartBuilderContainer(int windowIdIn, PlayerInventory playerInventoryIn, @Nullable PartBuilderTileEntity partBuilderTileEntity) {
        super((ContainerType)TinkerTables.partBuilderContainer.get(), windowIdIn, playerInventoryIn, partBuilderTileEntity);
        this.craftInventory = new PartBuilderInventoryWrapper(partBuilderTileEntity);
        this.craftResult = new CraftResultInventory();
        this.world = playerInventoryIn.field_70458_d.field_70170_p;
        this.outputSlot = new ResultSlot(this, playerInventoryIn.field_70458_d, this.craftResult, 0, 148, 33);
        this.func_75146_a(this.outputSlot);
        this.patternSlot = new PatternSlot(this, 8, 34);
        this.func_75146_a(this.patternSlot);
        this.inputSlot = new MaterialSlot(this, 29, 34);
        this.func_75146_a(this.inputSlot);
        this.addInventorySlots();
        this.func_216958_a(this.selectedRecipe);
        this.partFilter = recipe -> recipe.matchesPattern(this.craftInventory);
        this.updatePattern();
        this.craftInventory.updateMaterial();
        this.updateResult();
    }

    public PartBuilderContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, (PartBuilderTileEntity)PartBuilderContainer.getTileEntityFromBuf((PacketBuffer)buf, PartBuilderTileEntity.class));
    }

    @Nullable
    public PartRecipe getPartRecipe() {
        int index = this.selectedRecipe.func_221495_b();
        if (index < 0 || index >= this.partRecipes.size()) {
            return null;
        }
        return this.partRecipes.get(index);
    }

    @Nullable
    public MaterialRecipe getMaterialRecipe() {
        return this.craftInventory.getMaterial();
    }

    public void func_75130_a(IInventory inventoryIn) {
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (id >= 0 && id < this.partRecipes.size()) {
            this.selectedRecipe.func_221494_a(id);
            this.updateResult();
        }
        return true;
    }

    private void updatePattern() {
        this.partRecipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
        if (!this.patternSlot.func_75211_c().func_190926_b()) {
            this.partRecipes = RecipeHelper.getUIRecipes((RecipeManager)this.world.func_199532_z(), RecipeTypes.PART_BUILDER, PartRecipe.class, this.partFilter);
        }
        this.updateScreen();
    }

    private void updateResult() {
        PartRecipe recipe;
        ItemStack output = ItemStack.field_190927_a;
        if (this.patternSlot.func_75216_d() && this.inputSlot.func_75216_d() && (recipe = this.getPartRecipe()) != null && recipe.matches(this.craftInventory, this.world)) {
            output = recipe.getCraftingResult(this.craftInventory);
        }
        this.craftResult.func_70299_a(0, output);
        this.updateScreen();
    }

    public void onCrafting(PlayerEntity playerEntity, ItemStack output, IInventory craftMatrix) {
        PartRecipe recipe = this.getPartRecipe();
        if (recipe != null) {
            this.patternSlot.func_75209_a(1);
            this.inputSlot.func_75209_a(recipe.getItemsUsed(this.craftInventory));
            if (this.inputSlot.func_75211_c().func_190926_b()) {
                this.craftInventory.updateMaterial();
            }
            if (this.patternSlot.func_75211_c().func_190926_b()) {
                this.updatePattern();
            } else {
                this.updateResult();
            }
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public boolean hasPatternInPatternSlot() {
        return this.patternSlot.func_75216_d() && !this.partRecipes.isEmpty();
    }

    public int getSelectedPartRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    public List<PartRecipe> getPartRecipes() {
        return this.partRecipes;
    }

    public PartBuilderInventoryWrapper getCraftInventory() {
        return this.craftInventory;
    }

    public Slot getPatternSlot() {
        return this.patternSlot;
    }

    public Slot getInputSlot() {
        return this.inputSlot;
    }

    public Slot getOutputSlot() {
        return this.outputSlot;
    }

    public static class PatternSlot
    extends Slot {
        private final PartBuilderContainer container;

        private PatternSlot(PartBuilderContainer container, int x, int y) {
            super((IInventory)container.getTile(), 1, x, y);
            this.container = container;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() == TinkerTables.pattern.get();
        }

        public void func_75218_e() {
            super.func_75218_e();
            this.container.updatePattern();
        }
    }

    public static class MaterialSlot
    extends Slot {
        private final PartBuilderContainer container;
        @Nullable
        private Item lastItem;

        private MaterialSlot(PartBuilderContainer container, int x, int y) {
            super((IInventory)container.getTile(), 0, x, y);
            this.container = container;
        }

        public void func_75218_e() {
            super.func_75218_e();
            this.container.craftInventory.updateMaterial();
            this.container.updateResult();
        }
    }
}

