/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.inventory.table;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.inventory.BaseStationContainer;
import slimeknights.tconstruct.tables.inventory.SideInventoryContainer;
import slimeknights.tconstruct.tables.inventory.table.LazyResultSlot;
import slimeknights.tconstruct.tables.tileentity.table.CraftingStationTileEntity;

public class CraftingStationContainer
extends BaseStationContainer<CraftingStationTileEntity> {
    private final LazyResultSlot resultSlot;

    public CraftingStationContainer(int id, PlayerInventory inv, @Nullable CraftingStationTileEntity tile) {
        super((ContainerType)TinkerTables.craftingStationContainer.get(), id, inv, tile);
        if (tile != null) {
            tile.syncRecipe(inv.field_70458_d);
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.func_75146_a(new Slot((IInventory)tile, col + row * 3, 30 + col * 18, 17 + row * 18));
                }
            }
            this.resultSlot = new LazyResultSlot(tile.getCraftingResult(), 124, 35);
            this.func_75146_a(this.resultSlot);
            World world = tile.func_145831_w();
            if (world != null) {
                TileEntity inventoryTE = null;
                Direction accessDir = null;
                BlockPos pos = tile.func_174877_v();
                block2: for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos neighbor = pos.func_177972_a(dir);
                    for (Pair tinkerPos : this.stationBlocks) {
                        if (!((BlockPos)tinkerPos.getLeft()).equals((Object)neighbor)) continue;
                        continue block2;
                    }
                    TileEntity te = world.func_175625_s(neighbor);
                    if (te == null || !CraftingStationContainer.isUsable(te, inv.field_70458_d)) continue;
                    if (CraftingStationContainer.hasItemHandler(te, null)) {
                        inventoryTE = te;
                        accessDir = null;
                        break;
                    }
                    Direction side = dir.func_176734_d();
                    if (!CraftingStationContainer.hasItemHandler(te, side)) continue;
                    inventoryTE = te;
                    accessDir = side;
                    break;
                }
                if (inventoryTE != null) {
                    this.addSubContainer((Container)new SideInventoryContainer<Object>((ContainerType<?>)((ContainerType)TinkerTables.craftingStationContainer.get()), id, inv, inventoryTE, accessDir, -114, 8, 6), false);
                }
            }
        } else {
            this.resultSlot = null;
        }
        this.addInventorySlots();
    }

    public CraftingStationContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, (CraftingStationTileEntity)CraftingStationContainer.getTileEntityFromBuf((PacketBuffer)buf, CraftingStationTileEntity.class));
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == this.resultSlot) {
            if (this.tile != null && slot.func_75216_d()) {
                ItemStack original = slot.func_75211_c().func_77946_l();
                ItemStack result = ((CraftingStationTileEntity)this.tile).getResultForPlayer(player);
                if (!result.func_190926_b()) {
                    boolean nothingDone = true;
                    if (this.subContainers.size() > 0) {
                        nothingDone = this.refillAnyContainer(result, this.subContainers);
                    }
                    nothingDone &= this.moveToPlayerInventory(result);
                    if (this.subContainers.size() > 0) {
                        nothingDone &= this.moveToAnyContainer(result, this.subContainers);
                    }
                    if (!nothingDone) {
                        ((CraftingStationTileEntity)this.tile).takeResult(player, result, result.func_190916_E());
                        ((CraftingStationTileEntity)this.tile).getCraftingResult().func_174888_l();
                        return original;
                    }
                } else {
                    ((CraftingStationTileEntity)this.tile).notifyUncraftable(player);
                }
            }
            return ItemStack.field_190927_a;
        }
        return super.func_82846_b(player, index);
    }

    private static boolean isUsable(TileEntity tileEntity, PlayerEntity player) {
        return !TinkerTags.TileEntityTypes.CRAFTING_STATION_BLACKLIST.func_230235_a_((Object)tileEntity.func_200662_C()) && (!(tileEntity instanceof IInventory) || ((IInventory)tileEntity).func_70300_a(player));
    }

    private static boolean hasItemHandler(TileEntity tileEntity, @Nullable Direction direction) {
        return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).filter(cap -> cap instanceof IItemHandlerModifiable).isPresent();
    }

    public void func_75130_a(IInventory inventoryIn) {
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot != this.resultSlot && super.func_94530_a(stack, slot);
    }
}

