/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.MultiModuleContainer;
import slimeknights.tconstruct.tables.block.ITinkerStationBlock;
import slimeknights.tconstruct.tables.client.inventory.BaseStationScreen;

public class BaseStationContainer<TILE extends TileEntity>
extends MultiModuleContainer<TILE> {
    private static final TinkerBlockComp COMPARATOR = new TinkerBlockComp();
    public final List<Pair<BlockPos, BlockState>> stationBlocks = Lists.newLinkedList();

    public BaseStationContainer(ContainerType<?> containerType, int id, @Nullable PlayerInventory inv, @Nullable TILE tile) {
        super(containerType, id, inv, tile);
        if (tile != null && tile.func_145831_w() != null) {
            this.detectStationParts(tile.func_145831_w(), tile.func_174877_v());
        }
    }

    public void detectStationParts(World world, BlockPos start) {
        HashSet visited = Sets.newHashSet();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty()) {
            BlockState state;
            BlockPos pos = (BlockPos)queue.poll();
            if (visited.contains(pos) || !((state = world.func_180495_p(pos)).func_177230_c() instanceof ITinkerStationBlock)) continue;
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.func_177972_a(direction);
                if (visited.contains(offset)) continue;
                queue.add(offset);
            }
            visited.add(pos);
            this.stationBlocks.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos, (Object)state));
            if (this.stationBlocks.size() < 6) continue;
            break;
        }
        this.stationBlocks.sort(COMPARATOR);
    }

    public void updateScreen() {
        if (this.tile != null && this.tile.func_145831_w() != null && this.tile.func_145831_w().field_72995_K) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> BaseStationContainer::clientScreenUpdate);
        }
    }

    public void error(IFormattableTextComponent message) {
        if (this.tile != null && this.tile.func_145831_w() != null && this.tile.func_145831_w().field_72995_K) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BaseStationContainer.clientError(message));
        }
    }

    public void warning(IFormattableTextComponent message) {
        if (this.tile != null && this.tile.func_145831_w() != null && this.tile.func_145831_w().field_72995_K) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BaseStationContainer.clientWarning(message));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientScreenUpdate() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof BaseStationScreen) {
            ((BaseStationScreen)screen).updateDisplay();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientError(IFormattableTextComponent errorMessage) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof BaseStationScreen) {
            ((BaseStationScreen)screen).error((ITextComponent)errorMessage);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientWarning(IFormattableTextComponent warningMessage) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof BaseStationScreen) {
            ((BaseStationScreen)screen).warning((ITextComponent)warningMessage);
        }
    }

    private static class TinkerBlockComp
    implements Comparator<Pair<BlockPos, BlockState>> {
        private TinkerBlockComp() {
        }

        @Override
        public int compare(Pair<BlockPos, BlockState> o1, Pair<BlockPos, BlockState> o2) {
            int sum2;
            BlockPos pos1 = (BlockPos)o1.getLeft();
            BlockPos pos2 = (BlockPos)o2.getLeft();
            int sum1 = pos1.func_177958_n() + pos1.func_177956_o() + pos1.func_177952_p();
            if (sum1 != (sum2 = pos2.func_177958_n() + pos2.func_177956_o() + pos2.func_177952_p())) {
                return Integer.compare(sum1, sum2);
            }
            if (pos1.func_177956_o() != pos2.func_177956_o()) {
                return Integer.compare(pos1.func_177956_o(), pos2.func_177956_o());
            }
            if (pos1.func_177958_n() != pos2.func_177958_n()) {
                return Integer.compare(pos1.func_177958_n(), pos2.func_177958_n());
            }
            return Integer.compare(pos1.func_177952_p(), pos2.func_177952_p());
        }
    }
}

