/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.table;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ListIterator;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;

public class PartInfoPanelScreen
extends InfoPanelScreen {
    private static final String COST_KEY = Util.makeTranslationKey("gui", "part_builder.cost");
    private static final String MATERIAL_VALUE_KEY = Util.makeTranslationKey("gui", "part_builder.material_value");
    private ITextComponent patternCost = StringTextComponent.field_240750_d_;
    private ITextComponent materialValue = StringTextComponent.field_240750_d_;

    public PartInfoPanelScreen(MultiModuleScreen parent, Container container, PlayerInventory playerInventory, ITextComponent title) {
        super(parent, container, playerInventory, title);
    }

    public void clearPatternCost() {
        this.patternCost = StringTextComponent.field_240750_d_;
        this.updateSliderParameters();
    }

    public void setPatternCost(int cost) {
        this.patternCost = new TranslationTextComponent(COST_KEY, new Object[]{cost}).func_240699_a_(TextFormatting.GOLD);
        this.updateSliderParameters();
    }

    private boolean hasPatternCost() {
        return this.patternCost != null && this.patternCost != StringTextComponent.field_240750_d_;
    }

    public void setMaterialValue(ITextComponent value) {
        this.materialValue = new TranslationTextComponent(MATERIAL_VALUE_KEY, new Object[]{value}).func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)0x7FFFFF)));
        this.updateSliderParameters();
    }

    public void clearMaterialValue() {
        this.materialValue = StringTextComponent.field_240750_d_;
        this.updateSliderParameters();
    }

    private boolean hasMaterialValue() {
        return this.materialValue != null && this.materialValue != StringTextComponent.field_240750_d_;
    }

    @Override
    public int calcNeededHeight() {
        int neededHeight = 0;
        if (!this.hasInitialized()) {
            return this.field_230709_l_;
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            neededHeight += scaledFontHeight + 3;
        }
        if (this.hasPatternCost()) {
            neededHeight += scaledFontHeight + 3;
        }
        if (this.hasMaterialValue()) {
            neededHeight += scaledFontHeight + 3;
        }
        neededHeight = (int)((float)neededHeight + ((float)scaledFontHeight + 0.5f) * (float)this.getTotalLines().size());
        return neededHeight;
    }

    @Override
    protected float getTooltipStart(float y) {
        y = super.getTooltipStart(y);
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasPatternCost()) {
            y += (float)(scaledFontHeight + 3);
        }
        if (this.hasMaterialValue()) {
            y += (float)(scaledFontHeight + 3);
        }
        return y;
    }

    @Override
    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        int x2;
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_IMAGE);
        this.border.draw(matrices);
        BACKGROUND.drawScaled(matrices, this.field_147003_i + 4, this.field_147009_r + 4, this.field_146999_f - 8, this.field_147000_g - 8);
        float y = 5 + this.field_147009_r;
        float x = 5 + this.field_147003_i;
        int color = -986896;
        if (this.hasTooltips()) {
            this.field_230712_o_.func_238421_b_(matrices, "?", (float)(this.guiRight() - this.border.w) - (float)this.field_230712_o_.func_78256_a("?") / 2.0f, (float)(this.field_147009_r + 5), -10526881);
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            x2 = this.field_146999_f / 2;
            this.field_230712_o_.func_238407_a_(matrices, this.caption.func_230531_f_().func_240699_a_(TextFormatting.UNDERLINE).func_241878_f(), (float)this.field_147003_i + (float)(x2 -= this.field_230712_o_.func_238414_a_((ITextProperties)this.caption) / 2), y, color);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.hasPatternCost()) {
            x2 = this.field_146999_f / 2;
            this.field_230712_o_.func_238407_a_(matrices, this.patternCost.func_241878_f(), (float)this.field_147003_i + (float)(x2 -= this.field_230712_o_.func_238414_a_((ITextProperties)this.patternCost) / 2), y, color);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.hasMaterialValue()) {
            x2 = this.field_146999_f / 2;
            this.field_230712_o_.func_238407_a_(matrices, this.materialValue.func_241878_f(), (float)this.field_147003_i + (float)(x2 -= this.field_230712_o_.func_238414_a_((ITextProperties)this.materialValue) / 2), y, color);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.text == null || this.text.size() == 0) {
            return;
        }
        this.field_230712_o_.getClass();
        float textHeight = 9.0f + 0.5f;
        float lowerBound = (float)(this.field_147009_r + this.field_147000_g - 5) / this.textScale;
        RenderSystem.scalef((float)this.textScale, (float)this.textScale, (float)1.0f);
        x /= this.textScale;
        y /= this.textScale;
        ListIterator<IReorderingProcessor> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight - 0.5f > lowerBound)) {
            IReorderingProcessor line = iter.next();
            this.field_230712_o_.func_238407_a_(matrices, line, x, y, color);
            y += textHeight;
        }
        RenderSystem.scalef((float)(1.0f / this.textScale), (float)(1.0f / this.textScale), (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_IMAGE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.slider.update(mouseX, mouseY);
        this.slider.draw(matrices);
    }
}

