/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.table;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipe;
import slimeknights.tconstruct.tables.client.inventory.BaseStationScreen;
import slimeknights.tconstruct.tables.client.inventory.table.PartInfoPanelScreen;
import slimeknights.tconstruct.tables.inventory.table.partbuilder.PartBuilderContainer;
import slimeknights.tconstruct.tables.tileentity.table.PartBuilderTileEntity;

public class PartBuilderScreen
extends BaseStationScreen<PartBuilderTileEntity, PartBuilderContainer> {
    private static final ITextComponent INFO_TEXT = Util.makeTranslation("gui", "part_builder.info");
    private static final ITextComponent TRAIT_TITLE = Util.makeTranslation("gui", "part_builder.trait").func_240699_a_(TextFormatting.UNDERLINE);
    private static final IFormattableTextComponent UNCRAFTABLE_MATERIAL = Util.makeTranslation("gui", "part_builder.uncraftable").func_240699_a_(TextFormatting.RED);
    private static final IFormattableTextComponent UNCRAFTABLE_MATERIAL_TOOLTIP = Util.makeTranslation("gui", "part_builder.uncraftable.tooltip");
    private static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/partbuilder.png");
    protected PartInfoPanelScreen infoPanelScreen;
    private float sliderProgress = 0.0f;
    private boolean clickedOnScrollBar;
    private int recipeIndexOffset = 0;
    private boolean hasPatternInPatternSlot;

    public PartBuilderScreen(PartBuilderContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.infoPanelScreen = new PartInfoPanelScreen(this, (Container)container, playerInventory, title);
        this.infoPanelScreen.setTextScale(0.7777778f);
        this.infoPanelScreen.field_147000_g = this.field_147000_g;
        this.addModule(this.infoPanelScreen);
    }

    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(matrices, BACKGROUND);
        this.drawIconEmpty(matrices, ((PartBuilderContainer)this.field_147002_h).getPatternSlot(), Icons.PATTERN);
        this.drawIconEmpty(matrices, ((PartBuilderContainer)this.field_147002_h).getInputSlot(), Icons.INGOT);
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        this.func_238474_b_(matrices, this.cornerX + 126, this.cornerY + 15 + (int)(41.0f * this.sliderProgress), 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        this.drawRecipesBackground(matrices, mouseX, mouseY, this.cornerX + 51, this.cornerY + 15);
        this.drawRecipesItems(matrices, this.cornerX + 51, this.cornerY + 15);
        super.func_230450_a_(matrices, partialTicks, mouseX, mouseY);
    }

    private void drawRecipesBackground(MatrixStack matrices, int mouseX, int mouseY, int left, int top) {
        int max = Math.min(this.recipeIndexOffset + 12, this.getPartRecipeCount());
        for (int i = this.recipeIndexOffset; i < max; ++i) {
            int relative = i - this.recipeIndexOffset;
            int x = left + relative % 4 * 18;
            int y = top + relative / 4 * 18;
            int u = this.field_147000_g;
            if (i == ((PartBuilderContainer)this.field_147002_h).getSelectedPartRecipe()) {
                u += 18;
            } else if (mouseX >= x && mouseY >= y && mouseX < x + 18 && mouseY < y + 18) {
                u += 36;
            }
            this.func_238474_b_(matrices, x, y, 0, u, 18, 18);
        }
    }

    private void drawRecipesItems(MatrixStack matrices, int left, int top) {
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        Function spriteGetter = this.field_230706_i_.func_228015_a_(PlayerContainer.field_226615_c_);
        List<PartRecipe> list = ((PartBuilderContainer)this.field_147002_h).getPartRecipes();
        int max = Math.min(this.recipeIndexOffset + 12, this.getPartRecipeCount());
        for (int i = this.recipeIndexOffset; i < max; ++i) {
            int relative = i - this.recipeIndexOffset;
            int x = left + relative % 4 * 18 + 1;
            int y = top + relative / 4 * 18 + 1;
            PartRecipe recipe = list.get(i);
            ResourceLocation pattern = recipe.getPattern();
            TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(new ResourceLocation(pattern.func_110624_b(), "gui/tinker_pattern/" + pattern.func_110623_a()));
            PartBuilderScreen.func_238470_a_((MatrixStack)matrices, (int)x, (int)y, (int)100, (int)16, (int)16, (TextureAtlasSprite)sprite);
        }
    }

    @Override
    public void updateDisplay() {
        PartRecipe partRecipe;
        this.hasPatternInPatternSlot = ((PartBuilderContainer)this.field_147002_h).hasPatternInPatternSlot();
        if (!this.hasPatternInPatternSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
        if ((partRecipe = ((PartBuilderContainer)this.field_147002_h).getPartRecipe()) != null) {
            this.infoPanelScreen.setPatternCost(partRecipe.getCost());
        } else {
            this.infoPanelScreen.clearPatternCost();
        }
        MaterialRecipe materialRecipe = ((PartBuilderContainer)this.field_147002_h).getMaterialRecipe();
        if (materialRecipe != null) {
            this.setDisplayForMaterial(materialRecipe);
        } else {
            this.infoPanelScreen.setCaption(this.func_231171_q_());
            this.infoPanelScreen.setText(INFO_TEXT);
            this.infoPanelScreen.clearMaterialValue();
        }
    }

    private void setDisplayForMaterial(MaterialRecipe materialRecipe) {
        List<ModifierEntry> traits;
        IMaterial material = materialRecipe.getMaterial();
        this.infoPanelScreen.setCaption((ITextComponent)new TranslationTextComponent(material.getTranslationKey()).func_240700_a_(style -> style.func_240718_a_(material.getColor())));
        float value = materialRecipe.getMaterialValue(((PartBuilderContainer)this.field_147002_h).getCraftInventory());
        StringTextComponent formatted = new StringTextComponent(Util.df.format(value));
        PartRecipe partRecipe = ((PartBuilderContainer)this.field_147002_h).getPartRecipe();
        if (partRecipe != null && value < (float)partRecipe.getCost()) {
            formatted = formatted.func_240699_a_(TextFormatting.DARK_RED);
        }
        this.infoPanelScreen.setMaterialValue((ITextComponent)formatted);
        LinkedList stats = Lists.newLinkedList();
        ArrayList tips = Lists.newArrayList();
        if (!material.isCraftable()) {
            stats.add(UNCRAFTABLE_MATERIAL);
            stats.add(StringTextComponent.field_240750_d_);
            tips.add(UNCRAFTABLE_MATERIAL_TOOLTIP);
            tips.add(StringTextComponent.field_240750_d_);
        }
        if (!(traits = material.getTraits()).isEmpty()) {
            stats.add(TRAIT_TITLE);
            tips.add(StringTextComponent.field_240750_d_);
            for (ModifierEntry trait : traits) {
                Modifier mod = trait.getModifier();
                stats.add(mod.getDisplayName(trait.getLevel()));
                tips.add(mod.getDescription());
            }
            stats.add(StringTextComponent.field_240750_d_);
            tips.add(StringTextComponent.field_240750_d_);
        }
        for (IMaterialStats stat : MaterialRegistry.getInstance().getAllStats(material.getIdentifier())) {
            List<ITextComponent> info = stat.getLocalizedInfo();
            if (info.isEmpty()) continue;
            stats.add(stat.getLocalizedName().func_240699_a_(TextFormatting.UNDERLINE));
            tips.add(StringTextComponent.field_240750_d_);
            stats.addAll(info);
            tips.addAll(stat.getLocalizedDescriptions());
            stats.add(StringTextComponent.field_240750_d_);
            tips.add(StringTextComponent.field_240750_d_);
        }
        if (!stats.isEmpty() && ((ITextComponent)stats.get(stats.size() - 1)).getString().isEmpty()) {
            stats.remove(stats.size() - 1);
            tips.remove(tips.size() - 1);
        }
        this.infoPanelScreen.setText(stats, tips);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.clickedOnScrollBar = false;
        if (this.infoPanelScreen.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.hasPatternInPatternSlot) {
            int x = this.cornerX + 51;
            int y = this.cornerY + 15;
            int maxIndex = Math.min(this.recipeIndexOffset + 12, this.getPartRecipeCount());
            for (int l = this.recipeIndexOffset; l < maxIndex; ++l) {
                int relative = l - this.recipeIndexOffset;
                double buttonX = mouseX - (double)(x + relative % 4 * 18);
                double buttonY = mouseY - (double)(y + relative / 4 * 18);
                assert (this.field_230706_i_ != null);
                if (!(buttonX >= 0.0) || !(buttonY >= 0.0) || !(buttonX < 18.0) || !(buttonY < 18.0) || !((PartBuilderContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                assert (this.field_230706_i_.field_71442_b != null);
                this.field_230706_i_.field_71442_b.func_78756_a(((PartBuilderContainer)this.field_147002_h).field_75152_c, l);
                return true;
            }
            x = this.cornerX + 126;
            y = this.cornerY + 15;
            if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 54)) {
                this.clickedOnScrollBar = true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unknown) {
        if (this.infoPanelScreen.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.clickedOnScrollBar && this.canScroll()) {
            int i = this.cornerY + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unknown);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.infoPanelScreen.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = MathHelper.func_76131_a((float)((float)((double)this.sliderProgress - delta / (double)i)), (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)(this.sliderProgress * (float)i + 0.5f) * 4;
        }
        return true;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        if (this.infoPanelScreen.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.func_231048_c_(mouseX, mouseY, state);
    }

    @Override
    public void error(ITextComponent message) {
        this.infoPanelScreen.setCaption(COMPONENT_ERROR);
        this.infoPanelScreen.setText(message);
    }

    @Override
    public void warning(ITextComponent message) {
        this.infoPanelScreen.setCaption(COMPONENT_WARNING);
        this.infoPanelScreen.setText(message);
    }

    private int getPartRecipeCount() {
        return ((PartBuilderContainer)this.field_147002_h).getPartRecipes().size();
    }

    private boolean canScroll() {
        return this.hasPatternInPatternSlot && this.getPartRecipeCount() > 12;
    }

    private int getHiddenRows() {
        return (this.getPartRecipeCount() + 4 - 1) / 4 - 3;
    }
}

