/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.client.screen.SliderWidget;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.tables.client.inventory.module.BorderWidget;

public class InfoPanelScreen
extends ModuleScreen {
    private static final int resW = 118;
    private static final int resH = 75;
    protected static ResourceLocation BACKGROUND_IMAGE = Util.getResource("textures/gui/panel.png");
    protected static final ElementScreen TOP_LEFT = new ElementScreen(0, 0, 4, 4, 256, 256);
    protected static final ElementScreen TOP_RIGHT = new ElementScreen(122, 0, 4, 4);
    protected static final ElementScreen BOTTOM_LEFT = new ElementScreen(0, 79, 4, 4);
    protected static final ElementScreen BOTTOM_RIGHT = new ElementScreen(122, 79, 4, 4);
    protected static final ScalableElementScreen TOP = new ScalableElementScreen(4, 0, 118, 4);
    protected static final ScalableElementScreen BOTTOM = new ScalableElementScreen(4, 79, 118, 4);
    protected static final ScalableElementScreen LEFT = new ScalableElementScreen(0, 4, 4, 75);
    protected static final ScalableElementScreen RIGHT = new ScalableElementScreen(122, 4, 4, 75);
    protected static final ScalableElementScreen BACKGROUND = new ScalableElementScreen(4, 4, 118, 75);
    protected static final ElementScreen SLIDER_NORMAL = new ElementScreen(0, 83, 3, 5);
    protected static final ElementScreen SLIDER_HOVER = SLIDER_NORMAL.shift(InfoPanelScreen.SLIDER_NORMAL.w, 0);
    protected static final ScalableElementScreen SLIDER_BAR = new ScalableElementScreen(0, 88, 3, 8);
    protected static final ElementScreen SLIDER_TOP = new ElementScreen(3, 88, 3, 4);
    protected static final ElementScreen SLIDER_BOTTOM = new ElementScreen(3, 92, 3, 4);
    protected BorderWidget border = new BorderWidget();
    protected SliderWidget slider = new SliderWidget(SLIDER_NORMAL, SLIDER_HOVER, SLIDER_HOVER, SLIDER_TOP, SLIDER_BOTTOM, SLIDER_BAR);
    protected ITextComponent caption;
    protected List<ITextComponent> text;
    protected List<ITextComponent> tooltips;
    protected List<Integer> tooltipLines = Lists.newLinkedList();
    protected float textScale = 1.0f;

    public InfoPanelScreen(MultiModuleScreen parent, Container container, PlayerInventory playerInventory, ITextComponent title) {
        super(parent, container, playerInventory, title, true, false);
        this.border.borderTop = TOP;
        this.border.borderBottom = BOTTOM;
        this.border.borderLeft = LEFT;
        this.border.borderRight = RIGHT;
        this.border.cornerTopLeft = TOP_LEFT;
        this.border.cornerTopRight = TOP_RIGHT;
        this.border.cornerBottomLeft = BOTTOM_LEFT;
        this.border.cornerBottomRight = BOTTOM_RIGHT;
        this.field_146999_f = 126;
        this.field_147000_g = 83;
        this.caption = new TranslationTextComponent("gui.tconstruct.caption");
        this.text = Lists.newLinkedList();
    }

    public int getScaledFontHeight() {
        this.field_230712_o_.getClass();
        return (int)Math.ceil(9.0f * this.textScale);
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        super.func_231158_b_(mc, width, height);
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        this.border.setPosition(this.field_147003_i, this.field_147009_r);
        this.border.setSize(this.field_146999_f, this.field_147000_g);
        this.slider.setPosition(this.guiRight() - this.border.w - 2, this.field_147009_r + this.border.h + 12);
        this.slider.setSize(this.field_147000_g - this.border.h * 2 - 2 - 12);
        this.updateSliderParameters();
    }

    public void setCaption(ITextComponent caption) {
        this.caption = (IFormattableTextComponent)caption;
        this.updateSliderParameters();
    }

    public void setText(ITextComponent ... text) {
        ArrayList<ITextComponent> textComponents = new ArrayList<ITextComponent>(Arrays.asList(text));
        this.setText(textComponents, null);
    }

    public void setText(List<ITextComponent> text) {
        this.setText(text, null);
    }

    public void setText(List<ITextComponent> text, @Nullable List<ITextComponent> tooltips) {
        this.text = text;
        this.updateSliderParameters();
        this.setTooltips(tooltips);
    }

    protected void setTooltips(@Nullable List<ITextComponent> tooltips) {
        this.tooltips = tooltips;
    }

    public boolean hasCaption() {
        return this.caption != null && !this.caption.getString().isEmpty();
    }

    public boolean hasTooltips() {
        return this.tooltips != null && !this.tooltips.isEmpty();
    }

    public boolean hasInitialized() {
        return this.field_230712_o_ != null;
    }

    public int calcNeededHeight() {
        int neededHeight = 0;
        if (!this.hasInitialized()) {
            return this.field_230709_l_;
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            neededHeight += scaledFontHeight;
            neededHeight += 3;
        }
        neededHeight = (int)((float)neededHeight + ((float)scaledFontHeight + 0.5f) * (float)this.getTotalLines().size());
        return neededHeight;
    }

    protected void updateSliderParameters() {
        this.slider.hide();
        int h = this.field_147000_g - 10;
        if (this.calcNeededHeight() <= h) {
            return;
        }
        this.slider.show();
        int scaledFontHeight = this.getScaledFontHeight();
        int neededHeight = this.calcNeededHeight();
        int hiddenRows = (neededHeight - h) / scaledFontHeight;
        if ((neededHeight - h) % scaledFontHeight > 0) {
            ++hiddenRows;
        }
        this.slider.setSliderParameters(0, hiddenRows, 1);
    }

    protected List<IReorderingProcessor> getTotalLines() {
        int w = this.field_146999_f - this.border.w * 2 + 2;
        if (!this.slider.isHidden()) {
            w -= this.slider.width + 3;
        }
        w = (int)((float)w / this.textScale);
        LinkedList lines = Lists.newLinkedList();
        this.tooltipLines.clear();
        for (ITextComponent textComponent : this.text) {
            this.tooltipLines.add(lines.size());
            if (textComponent.getString().isEmpty()) {
                lines.add(StringTextComponent.field_240750_d_.func_241878_f());
                continue;
            }
            lines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)textComponent, w));
        }
        return lines;
    }

    public InfoPanelScreen wood() {
        this.shift(126, 0);
        this.shiftSlider(6, 0);
        return this;
    }

    public InfoPanelScreen metal() {
        this.shift(126, 83);
        this.shiftSlider(12, 0);
        return this;
    }

    private void shift(int xd, int yd) {
        this.border.borderTop = TOP.shift(xd, yd);
        this.border.borderBottom = BOTTOM.shift(xd, yd);
        this.border.borderLeft = LEFT.shift(xd, yd);
        this.border.borderRight = RIGHT.shift(xd, yd);
        this.border.cornerTopLeft = TOP_LEFT.shift(xd, yd);
        this.border.cornerTopRight = TOP_RIGHT.shift(xd, yd);
        this.border.cornerBottomLeft = BOTTOM_LEFT.shift(xd, yd);
        this.border.cornerBottomRight = BOTTOM_RIGHT.shift(xd, yd);
    }

    private void shiftSlider(int xd, int yd) {
        this.slider = new SliderWidget(SLIDER_NORMAL.shift(xd, yd), SLIDER_HOVER.shift(xd, yd), SLIDER_HOVER.shift(xd, yd), SLIDER_TOP.shift(xd, yd), SLIDER_BOTTOM.shift(xd, yd), SLIDER_BAR.shift(xd, yd));
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    protected void func_230459_a_(MatrixStack matrices, int mouseX, int mouseY) {
        int i;
        super.func_230459_a_(matrices, mouseX, mouseY);
        if (this.tooltips == null) {
            return;
        }
        if (mouseX < this.field_147003_i || mouseX > this.guiRight()) {
            return;
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasTooltips() && mouseX >= this.guiRight() - this.border.w - this.field_230712_o_.func_78256_a("?") / 2 && mouseX < this.guiRight() && mouseY > this.field_147009_r + 5 && mouseY < this.field_147009_r + 5 + scaledFontHeight) {
            this.func_238654_b_(matrices, this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.tconstruct.general.hover"), 150), mouseX - 155, mouseY);
        }
        float y = this.getTooltipStart(5 + this.field_147009_r);
        this.field_230712_o_.getClass();
        float textHeight = (9.0f + 0.5f) * this.textScale;
        float lowerBound = this.field_147009_r + this.field_147000_g - 5;
        int index = -1;
        ListIterator<IReorderingProcessor> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight > lowerBound)) {
            if ((float)mouseY > y && (float)mouseY <= y + textHeight) {
                index = iter.nextIndex();
                break;
            }
            iter.next();
            y += textHeight;
        }
        if (index < 0) {
            return;
        }
        for (i = 0; this.tooltipLines.size() > i && index > this.tooltipLines.get(i); ++i) {
        }
        if (i >= this.tooltips.size() || this.tooltips.get(i).getString().isEmpty()) {
            return;
        }
        int w = MathHelper.func_76125_a((int)(this.field_230708_k_ - mouseX - 12), (int)0, (int)200);
        if (w < 100) {
            mouseX -= 100 - w;
            w = 100;
        }
        List lines = this.field_230712_o_.func_238425_b_((ITextProperties)this.tooltips.get(i), w);
        this.func_238654_b_(matrices, lines, mouseX, mouseY - lines.size() * this.getScaledFontHeight() / 2);
    }

    protected float getTooltipStart(float y) {
        if (this.hasCaption()) {
            y += (float)(this.getScaledFontHeight() + 3);
        }
        return y;
    }

    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_IMAGE);
        this.border.draw(matrices);
        BACKGROUND.drawScaled(matrices, this.field_147003_i + 4, this.field_147009_r + 4, this.field_146999_f - 8, this.field_147000_g - 8);
        float y = 5 + this.field_147009_r;
        float x = 5 + this.field_147003_i;
        int color = -986896;
        if (this.hasTooltips()) {
            this.field_230712_o_.func_238421_b_(matrices, "?", (float)(this.guiRight() - this.border.w) - (float)this.field_230712_o_.func_78256_a("?") / 2.0f, (float)(this.field_147009_r + 5), -10526881);
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            int x2 = this.field_146999_f / 2;
            this.field_230712_o_.func_238407_a_(matrices, this.caption.func_230531_f_().func_240699_a_(TextFormatting.UNDERLINE).func_241878_f(), (float)this.field_147003_i + (float)(x2 -= this.field_230712_o_.func_238414_a_((ITextProperties)this.caption) / 2), y, color);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.text == null || this.text.size() == 0) {
            return;
        }
        this.field_230712_o_.getClass();
        float textHeight = 9.0f + 0.5f;
        float lowerBound = (float)(this.field_147009_r + this.field_147000_g - 5) / this.textScale;
        RenderSystem.scalef((float)this.textScale, (float)this.textScale, (float)1.0f);
        x /= this.textScale;
        y /= this.textScale;
        ListIterator<IReorderingProcessor> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight - 0.5f > lowerBound)) {
            IReorderingProcessor line = iter.next();
            this.field_230712_o_.func_238407_a_(matrices, line, x, y, color);
            y += textHeight;
        }
        RenderSystem.scalef((float)(1.0f / this.textScale), (float)(1.0f / this.textScale), (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_IMAGE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.slider.update(mouseX, mouseY);
        this.slider.draw(matrices);
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.slider.isEnabled()) {
            return false;
        }
        if (mouseButton == 0 && mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height)) {
            this.slider.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return false;
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (!this.slider.isEnabled()) {
            return false;
        }
        this.slider.handleMouseReleased();
        return mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height);
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollData) {
        if (!this.slider.isEnabled() || !this.isMouseInModule((int)mouseX, (int)mouseY) || this.isMouseOverFullSlot(mouseX, mouseY)) {
            return false;
        }
        return this.slider.mouseScrolled(scrollData, true);
    }

    public void setTextScale(float textScale) {
        this.textScale = textScale;
    }
}

