/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.library.slots;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.tables.client.inventory.library.slots.SlotPosition;

public class SlotInformation {
    public static final SlotInformation EMPTY = new SlotInformation(Collections.emptyList(), SlotPosition.EMPTY, Items.field_190931_a, -1);
    private final List<SlotPosition> points;
    private final SlotPosition toolSlot;
    private final Item item;
    private final int sortIndex;
    private ItemStack toolForRendering;

    public static SlotInformation fromJson(JsonObject json) {
        List<SlotPosition> slots = SlotPosition.listFromJson(json, "slots");
        Item item = Items.field_190931_a;
        if (json.has("item")) {
            item = JSONUtils.func_188180_i((JsonObject)json, (String)"item");
        }
        SlotPosition slotPosition = new SlotPosition(-1, -1);
        if (json.has("tool")) {
            slotPosition = SlotPosition.fromJson(json.get("tool").getAsJsonObject());
        }
        int sortIndex = JSONUtils.func_151203_m((JsonObject)json, (String)"sortIndex");
        return new SlotInformation(slots, slotPosition, item, sortIndex);
    }

    public ItemStack getToolForRendering() {
        if (this.toolForRendering == null || this.toolForRendering.func_190926_b()) {
            this.toolForRendering = this.item instanceof ToolCore ? ((ToolCore)this.item).buildToolForRendering() : new ItemStack((IItemProvider)this.item);
        }
        return this.toolForRendering;
    }

    public boolean isRepair() {
        return this.item == Items.field_190931_a;
    }

    public SlotInformation(List<SlotPosition> points, SlotPosition toolSlot, Item item, int sortIndex) {
        this.points = points;
        this.toolSlot = toolSlot;
        this.item = item;
        this.sortIndex = sortIndex;
    }

    public List<SlotPosition> getPoints() {
        return this.points;
    }

    public SlotPosition getToolSlot() {
        return this.toolSlot;
    }

    public Item getItem() {
        return this.item;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }
}

