/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.library;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.client.screen.SliderWidget;
import slimeknights.tconstruct.tables.client.inventory.module.GenericScreen;

public class DynInventoryScreen
extends ModuleScreen {
    protected static final ScalableElementScreen slot = GenericScreen.slot;
    private static final ScalableElementScreen slotEmpty = GenericScreen.slotEmpty;
    protected static final ElementScreen sliderNormal = GenericScreen.sliderNormal;
    protected static final ElementScreen sliderLow = GenericScreen.sliderLow;
    protected static final ElementScreen sliderHigh = GenericScreen.sliderHigh;
    protected static final ElementScreen sliderTop = GenericScreen.sliderTop;
    protected static final ElementScreen sliderBottom = GenericScreen.sliderBottom;
    protected static final ScalableElementScreen sliderBackground = GenericScreen.sliderBackground;
    protected SliderWidget slider = new SliderWidget(sliderNormal, sliderHigh, sliderLow, sliderTop, sliderBottom, sliderBackground);
    protected int columns;
    protected int rows;
    protected int slotCount;
    protected boolean sliderActive;
    protected int firstSlotId;
    protected int lastSlotId;
    protected final Container field_147002_h;

    public DynInventoryScreen(MultiModuleScreen<?> parent, Container container, PlayerInventory playerInventory, ITextComponent title) {
        super(parent, container, playerInventory, title, false, false);
        this.field_147002_h = container;
        this.xOffset = 7;
        this.yOffset = 17;
        this.field_146999_f = 162;
        this.field_147000_g = 54;
        this.slotCount = container.field_75151_b.size();
        this.firstSlotId = 0;
        this.lastSlotId = this.slotCount;
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        this.field_147003_i = parentX + this.xOffset;
        this.field_147009_r = parentY + this.yOffset;
        this.columns = this.field_146999_f / DynInventoryScreen.slot.w;
        this.rows = this.field_147000_g / DynInventoryScreen.slot.h;
        this.sliderActive = this.slotCount > this.columns * this.rows;
        this.updateSlider();
        if (this.sliderActive) {
            this.columns = (this.field_146999_f - this.slider.width) / DynInventoryScreen.slot.w;
            this.updateSlider();
        }
        this.updateSlots();
    }

    protected void updateSlider() {
        int max = 0;
        if (this.sliderActive) {
            this.slider.show();
            max = this.slotCount / this.columns - this.rows + 1;
        } else {
            this.slider.hide();
        }
        this.slider.setPosition(this.field_147003_i + this.field_146999_f - this.slider.width, this.field_147009_r);
        this.slider.setSize(this.field_147000_g);
        this.slider.setSliderParameters(0, max, 1);
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.sliderActive) {
            return false;
        }
        if (mouseButton == 0 && mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height)) {
            this.slider.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return false;
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (!this.sliderActive) {
            return false;
        }
        this.slider.handleMouseReleased();
        return mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height);
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollData) {
        if (!this.sliderActive) {
            return false;
        }
        return this.slider.mouseScrolled(scrollData, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule((int)mouseX, (int)mouseY));
    }

    public void update(int mouseX, int mouseY) {
        if (!this.sliderActive) {
            return;
        }
        this.slider.update(mouseX, mouseY);
        this.updateSlots();
    }

    public boolean shouldDrawSlot(Slot slot) {
        if (!this.slider.isEnabled()) {
            return true;
        }
        int index = slot.getSlotIndex();
        return this.firstSlotId <= index && this.lastSlotId > index;
    }

    public void updateSlots() {
        this.firstSlotId = this.slider.getValue() * this.columns;
        this.lastSlotId = Math.min(this.slotCount, this.firstSlotId + this.rows * this.columns);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (this.shouldDrawSlot(slot)) {
                int offset = slot.getSlotIndex() - this.firstSlotId;
                int x = offset % this.columns * DynInventoryScreen.slot.w;
                int y = offset / this.columns * DynInventoryScreen.slot.h;
                slot.field_75223_e = this.xOffset + x + 1;
                slot.field_75221_f = this.yOffset + y + 1;
                continue;
            }
            slot.field_75223_e = 0;
            slot.field_75221_f = 0;
        }
    }

    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        int y;
        this.field_230706_i_.func_110434_K().func_110577_a(GenericScreen.LOCATION);
        if (!this.slider.isHidden()) {
            this.slider.draw(matrices);
            this.updateSlots();
        }
        int fullRows = (this.lastSlotId - this.firstSlotId) / this.columns;
        int w = this.columns * DynInventoryScreen.slot.w;
        for (y = 0; y < fullRows * DynInventoryScreen.slot.h && y < this.field_147000_g; y += DynInventoryScreen.slot.h) {
            slot.drawScaledX(matrices, this.field_147003_i, this.field_147009_r + y, w);
        }
        int slotsLeft = (this.lastSlotId - this.firstSlotId) % this.columns;
        if (slotsLeft > 0) {
            slot.drawScaledX(matrices, this.field_147003_i, this.field_147009_r + y, slotsLeft * DynInventoryScreen.slot.w);
            slotEmpty.drawScaledX(matrices, this.field_147003_i + slotsLeft * DynInventoryScreen.slot.w, this.field_147009_r + y, w - slotsLeft * DynInventoryScreen.slot.w);
        }
    }
}

