/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.tables.block.ITinkerStationBlock;
import slimeknights.tconstruct.tables.client.inventory.module.TinkerTabsScreen;
import slimeknights.tconstruct.tables.inventory.BaseStationContainer;
import slimeknights.tconstruct.tables.network.StationTabPacket;

public class BaseStationScreen<TILE extends TileEntity, CONTAINER extends BaseStationContainer<TILE>>
extends MultiModuleScreen<CONTAINER> {
    protected static final ITextComponent COMPONENT_WARNING = Util.makeTranslation("gui", "warning");
    protected static final ITextComponent COMPONENT_ERROR = Util.makeTranslation("gui", "error");
    public static final ResourceLocation BLANK_BACK = Util.getResource("textures/gui/blank.png");
    protected final TILE tile;
    protected final CONTAINER field_147002_h;
    protected TinkerTabsScreen tabsScreen;

    public BaseStationScreen(CONTAINER container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        World world;
        this.tile = container.getTile();
        this.field_147002_h = container;
        this.tabsScreen = new TinkerTabsScreen(this, (Container)container, playerInventory, title);
        this.addModule(this.tabsScreen);
        if (this.tile != null && (world = this.tile.func_145831_w()) != null) {
            for (Pair<BlockPos, BlockState> pair : ((BaseStationContainer)((Object)container)).stationBlocks) {
                BlockState state = (BlockState)pair.getRight();
                BlockPos blockPos = (BlockPos)pair.getLeft();
                ItemStack stack = state.func_177230_c().getPickBlock(state, null, (IBlockReader)world, blockPos, playerInventory.field_70458_d);
                this.tabsScreen.addTab(stack, blockPos);
            }
        }
        for (int i = 0; i < this.tabsScreen.tabData.size(); ++i) {
            if (!this.tabsScreen.tabData.get(i).equals((Object)this.tile.func_174877_v())) continue;
            this.tabsScreen.tabs.selected = i;
        }
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    protected void drawIcon(MatrixStack matrices, Slot slot, ElementScreen element) {
        this.field_230706_i_.func_110434_K().func_110577_a(Icons.ICONS);
        element.draw(matrices, slot.field_75223_e + this.cornerX - 1, slot.field_75221_f + this.cornerY - 1);
    }

    protected void drawIconEmpty(MatrixStack matrices, Slot slot, ElementScreen element) {
        if (slot.func_75216_d()) {
            return;
        }
        this.drawIcon(matrices, slot, element);
    }

    public void onTabSelection(int selection) {
        if (selection < 0 || selection > this.tabsScreen.tabData.size()) {
            return;
        }
        World world = this.tile.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = this.tabsScreen.tabData.get(selection);
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ITinkerStationBlock) {
            TileEntity te = this.tile.func_145831_w().func_175625_s(pos);
            TinkerNetwork.getInstance().sendToServer(new StationTabPacket(pos));
            assert (this.field_230706_i_ != null);
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    public void error(ITextComponent message) {
    }

    public void warning(ITextComponent message) {
    }

    public void updateDisplay() {
    }
}

