/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.tables.client.inventory.library.slots.SlotInformation;

public class SlotInformationLoader
extends JsonReloadListener {
    private static final Logger log = LogManager.getLogger(SlotInformationLoader.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final SlotInformationLoader INSTANCE = new SlotInformationLoader();
    private final Map<ResourceLocation, SlotInformation> slotInformationMap = new HashMap<ResourceLocation, SlotInformation>();
    private final List<SlotInformation> slotInformationList = new ArrayList<SlotInformation>();

    private SlotInformationLoader() {
        super(GSON, "tinker_station");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, IResourceManager resourceManager, IProfiler profiler) {
        this.slotInformationMap.clear();
        this.slotInformationList.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation location = entry.getKey();
            try {
                JsonObject json = entry.getValue().getAsJsonObject();
                this.slotInformationMap.put(location, SlotInformation.fromJson(json));
            }
            catch (Exception e) {
                log.warn("Exception loading slot information '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
        this.slotInformationList.addAll(this.slotInformationMap.values());
        this.slotInformationList.sort(Comparator.comparing(SlotInformation::getSortIndex));
    }

    public static SlotInformation get(ResourceLocation registryKey) {
        return SlotInformationLoader.INSTANCE.slotInformationMap.getOrDefault(registryKey, SlotInformation.EMPTY);
    }

    public static Collection<SlotInformation> getSlotInformationList() {
        return SlotInformationLoader.INSTANCE.slotInformationList;
    }
}

