/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.multiblock;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockStructureData;

public abstract class MultiblockCuboid<T extends MultiblockStructureData> {
    private static final int NORTH = Direction.NORTH.func_176736_b();
    private static final int EAST = Direction.EAST.func_176736_b();
    private static final int SOUTH = Direction.SOUTH.func_176736_b();
    private static final int WEST = Direction.WEST.func_176736_b();
    protected final boolean hasFloor;
    protected final boolean hasFrame;
    protected final boolean hasCeiling;
    private final int maxHeight;
    private final int innerLimit;

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this(hasFloor, hasFrame, hasCeiling, 64, 14);
    }

    @Nullable
    public T detectMultiblock(World world, BlockPos master, Direction facing) {
        int height;
        ImmutableSet.Builder extraBlocks = ImmutableSet.builder();
        BlockPos center = this.getOuterPos(world, master.func_177972_a(facing.func_176734_d()), Direction.DOWN, this.maxHeight).func_177984_a();
        if (!this.hasFrame && master.func_177956_o() < center.func_177956_o()) {
            return null;
        }
        int[] edges = new int[4];
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.getOuterPos(world, center, direction, this.innerLimit);
            edges[direction.func_176736_b()] = pos.func_177958_n() - center.func_177958_n() + (pos.func_177952_p() - center.func_177952_p());
        }
        int xd = edges[SOUTH] - edges[NORTH] - 1;
        int zd = edges[EAST] - edges[WEST] - 1;
        if (xd > this.innerLimit || zd > this.innerLimit) {
            return null;
        }
        BlockPos from = center.func_177982_a(edges[WEST], 0, edges[NORTH]);
        BlockPos to = center.func_177982_a(edges[EAST], 0, edges[SOUTH]);
        Consumer<Collection<BlockPos>> posConsumer = arg_0 -> ((ImmutableSet.Builder)extraBlocks).addAll(arg_0);
        if (this.hasFloor && !this.detectCap(world, from.func_177977_b(), to.func_177977_b(), CuboidSide.FLOOR, posConsumer)) {
            return null;
        }
        int localMax = Math.min(this.maxHeight, world.func_217301_I() - center.func_177956_o());
        for (height = 0; height < localMax && this.detectLayer(world, from.func_177981_b(height), to.func_177981_b(height), posConsumer); ++height) {
        }
        if (height <= master.func_177956_o() - center.func_177956_o()) {
            return null;
        }
        if (this.hasCeiling && !this.detectCap(world, from.func_177981_b(height), to.func_177981_b(height), CuboidSide.CEILING, posConsumer)) {
            return null;
        }
        BlockPos minPos = this.hasFloor ? from.func_177977_b() : from;
        BlockPos maxPos = to.func_177981_b(this.hasCeiling ? height : height - 1);
        return this.create(minPos, maxPos, (Set<BlockPos>)extraBlocks.build());
    }

    protected BlockPos getOuterPos(World world, BlockPos pos, Direction direction, int limit) {
        for (int i = 0; i < limit && world.func_175667_e(pos) && this.isInnerBlock(world, pos); ++i) {
            pos = pos.func_177972_a(direction);
        }
        return pos;
    }

    protected boolean detectCap(World world, BlockPos from, BlockPos to, CuboidSide side, Consumer<Collection<BlockPos>> consumer) {
        int x;
        if (!world.func_175707_a(from, to)) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int height = from.func_177956_o();
        if (this.hasFrame) {
            Predicate<BlockPos> frameCheck = pos -> this.isValidBlock(world, (BlockPos)pos, side, true);
            for (x = from.func_177958_n(); x <= to.func_177958_n(); ++x) {
                if (!frameCheck.test((BlockPos)mutable.func_181079_c(x, height, from.func_177952_p()))) {
                    return false;
                }
                if (frameCheck.test((BlockPos)mutable.func_181079_c(x, height, to.func_177952_p()))) continue;
                return false;
            }
            for (int z = from.func_177952_p() + 1; z < to.func_177952_p(); ++z) {
                if (!frameCheck.test((BlockPos)mutable.func_181079_c(from.func_177958_n(), height, z))) {
                    return false;
                }
                if (frameCheck.test((BlockPos)mutable.func_181079_c(to.func_177958_n(), height, z))) continue;
                return false;
            }
        }
        for (int z = from.func_177952_p() + 1; z < to.func_177952_p(); ++z) {
            for (x = from.func_177958_n() + 1; x < to.func_177958_n(); ++x) {
                if (this.isValidBlock(world, (BlockPos)mutable.func_181079_c(x, height, z), side, false)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean detectLayer(World world, BlockPos from, BlockPos to, Consumer<Collection<BlockPos>> consumer) {
        int z;
        if (!world.func_175707_a(from, to)) {
            return false;
        }
        ArrayList candidates = Lists.newArrayList();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int height = from.func_177956_o();
        if (this.hasFrame) {
            Predicate<BlockPos> frameCheck = pos -> this.isValidBlock(world, (BlockPos)pos, CuboidSide.WALL, true);
            if (!frameCheck.test(from)) {
                return false;
            }
            if (!frameCheck.test(to)) {
                return false;
            }
            if (!frameCheck.test((BlockPos)mutable.func_181079_c(to.func_177958_n(), height, from.func_177952_p()))) {
                return false;
            }
            if (!frameCheck.test((BlockPos)mutable.func_181079_c(from.func_177958_n(), height, to.func_177952_p()))) {
                return false;
            }
        }
        for (int x = from.func_177958_n() + 1; x < to.func_177958_n(); ++x) {
            for (z = from.func_177952_p() + 1; z < to.func_177952_p(); ++z) {
                mutable.func_181079_c(x, height, z);
                if (this.isInnerBlock(world, (BlockPos)mutable)) {
                    if (world.func_175623_d((BlockPos)mutable)) continue;
                    candidates.add(mutable.func_185334_h());
                    continue;
                }
                return false;
            }
        }
        Predicate<BlockPos> wallCheck = pos -> this.isValidBlock(world, (BlockPos)pos, CuboidSide.WALL, false);
        for (int x = from.func_177958_n() + 1; x < to.func_177958_n(); ++x) {
            if (!wallCheck.test((BlockPos)mutable.func_181079_c(x, height, from.func_177952_p()))) {
                return false;
            }
            if (wallCheck.test((BlockPos)mutable.func_181079_c(x, height, to.func_177952_p()))) continue;
            return false;
        }
        for (z = from.func_177952_p() + 1; z < to.func_177952_p(); ++z) {
            if (!wallCheck.test((BlockPos)mutable.func_181079_c(from.func_177958_n(), height, z))) {
                return false;
            }
            if (wallCheck.test((BlockPos)mutable.func_181079_c(to.func_177958_n(), height, z))) continue;
            return false;
        }
        consumer.accept(candidates);
        return true;
    }

    protected abstract boolean isValidBlock(World var1, BlockPos var2, CuboidSide var3, boolean var4);

    public boolean isInnerBlock(World world, BlockPos pos) {
        return world.func_175623_d(pos);
    }

    public abstract boolean shouldUpdate(World var1, MultiblockStructureData var2, BlockPos var3, BlockState var4);

    @Nullable
    public T readFromNBT(CompoundNBT nbt) {
        BlockPos minPos = TagUtil.readPos(nbt, "min");
        BlockPos maxPos = TagUtil.readPos(nbt, "max");
        if (minPos == null || maxPos == null) {
            return null;
        }
        ImmutableSet extra = ImmutableSet.copyOf(MultiblockCuboid.readPosList(nbt, "extra"));
        return this.create(minPos, maxPos, (Set<BlockPos>)extra);
    }

    public abstract T create(BlockPos var1, BlockPos var2, Set<BlockPos> var3);

    protected static Collection<BlockPos> readPosList(CompoundNBT rootTag, String key) {
        List<BlockPos> collection;
        if (rootTag.func_150297_b(key, 9)) {
            ListNBT list = rootTag.func_150295_c(key, 10);
            collection = new ArrayList<BlockPos>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                BlockPos pos = TagUtil.readPos(list.func_150305_b(i));
                if (pos == null) continue;
                collection.add(pos);
            }
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling, int maxHeight, int innerLimit) {
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
        this.hasCeiling = hasCeiling;
        this.maxHeight = maxHeight;
        this.innerLimit = innerLimit;
    }

    public static enum CuboidSide {
        FLOOR,
        CEILING,
        WALL;

    }
}

