/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.module;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IIntArray;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModule;

public class MeltingModuleInventory
implements IItemHandlerModifiable {
    private static final String TAG_SLOT = "slot";
    private static final String TAG_ITEMS = "items";
    private static final String TAG_SIZE = "size";
    private final MantleTileEntity parent;
    private final IFluidHandler fluidHandler;
    private MeltingModule[] modules;
    private final boolean strictSize;
    private final IntSupplier nuggetsPerOre;
    private final Predicate<FluidStack> outputFunction = this::tryFillTank;

    public MeltingModuleInventory(MantleTileEntity parent, IFluidHandler fluidHandler, IntSupplier nuggetsPerOre, int size) {
        this.parent = parent;
        this.fluidHandler = fluidHandler;
        this.modules = new MeltingModule[size];
        this.nuggetsPerOre = nuggetsPerOre;
        this.strictSize = size != 0;
    }

    public MeltingModuleInventory(MantleTileEntity parent, IFluidHandler fluidHandler, IntSupplier nuggetsPerOre) {
        this(parent, fluidHandler, nuggetsPerOre, 0);
    }

    public int getSlots() {
        return this.modules.length;
    }

    public boolean validSlot(int slot) {
        return slot >= 0 && slot < this.getSlots();
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    private boolean hasModule(int slot) {
        return this.validSlot(slot) && this.modules[slot] != null;
    }

    public int getCurrentTime(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getCurrentTime() : 0;
    }

    public int getRequiredTime(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getRequiredTime() : 0;
    }

    public int getRequiredTemp(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getRequiredTemp() : 0;
    }

    public MeltingModule getModule(int slot) {
        if (!this.validSlot(slot)) {
            throw new IndexOutOfBoundsException();
        }
        if (this.modules[slot] == null) {
            this.modules[slot] = new MeltingModule(this.parent, this.outputFunction, this.nuggetsPerOre, slot);
        }
        return this.modules[slot];
    }

    public void resize(int newSize, Consumer<ItemStack> stackConsumer) {
        if (this.strictSize) {
            throw new IllegalStateException("Cannot resize this melting module inventory");
        }
        if (newSize == this.modules.length) {
            return;
        }
        if (newSize < this.modules.length) {
            for (int i = newSize; i < this.modules.length; ++i) {
                if (this.modules[i] == null || this.modules[i].getStack().func_190926_b()) continue;
                stackConsumer.accept(this.modules[i].getStack());
            }
        }
        this.modules = Arrays.copyOf(this.modules, newSize);
        this.parent.markDirtyFast();
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.validSlot(slot) && this.modules[slot] != null) {
            return this.modules[slot].getStack();
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.validSlot(slot)) {
            if (stack.func_190926_b()) {
                if (this.modules[slot] != null) {
                    this.modules[slot].setStack(ItemStack.field_190927_a);
                }
            } else {
                if (stack.func_190916_E() > 1) {
                    stack.func_190920_e(1);
                }
                this.getModule(slot).setStack(stack);
            }
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (slot < 0 || slot >= this.getSlots()) {
            return stack;
        }
        MeltingModule module = this.getModule(slot);
        boolean canInsert = module.getStack().func_190926_b();
        if (!simulate && canInsert) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        return canInsert ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1)) : stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        if (!this.validSlot(slot)) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            return existing.func_77946_l();
        }
        this.setStackInSlot(slot, ItemStack.field_190927_a);
        return existing;
    }

    public boolean canHeat(int temperature) {
        for (MeltingModule module : this.modules) {
            if (module == null || !module.canHeatItem(temperature)) continue;
            return true;
        }
        return false;
    }

    protected boolean tryFillTank(FluidStack fluid) {
        if (this.fluidHandler.fill(fluid.copy(), IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount()) {
            this.fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public void heatItems(int temperature) {
        for (MeltingModule module : this.modules) {
            if (module == null) continue;
            module.heatItem(temperature);
        }
    }

    public void coolItems() {
        for (MeltingModule module : this.modules) {
            if (module == null) continue;
            module.coolItem();
        }
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null || this.modules[i].getStack().func_190926_b()) continue;
            CompoundNBT moduleNBT = this.modules[i].writeToNBT();
            moduleNBT.func_74774_a(TAG_SLOT, (byte)i);
            list.add((Object)moduleNBT);
        }
        if (!list.isEmpty()) {
            nbt.func_218657_a(TAG_ITEMS, (INBT)list);
        }
        nbt.func_74774_a(TAG_SIZE, (byte)this.modules.length);
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
        if (!this.strictSize) {
            this.modules = new MeltingModule[nbt.func_74771_c(TAG_SIZE) & 0xFF];
        }
        ListNBT list = nbt.func_150295_c(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            int slot;
            CompoundNBT item = list.func_150305_b(i);
            if (!item.func_150297_b(TAG_SLOT, 1) || !this.validSlot(slot = item.func_74771_c(TAG_SLOT) & 0xFF)) continue;
            this.getModule(slot).readFromNBT(item);
        }
    }

    public void trackInts(Consumer<IIntArray> consumer) {
        for (int i = 0; i < this.getSlots(); ++i) {
            consumer.accept(this.getModule(i));
        }
    }
}

